/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.kms.action;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.connect.amazon.core.model.KMSKeyId;
import org.http4k.connect.amazon.kms.action.Sign;
import org.http4k.connect.amazon.kms.model.SigningAlgorithm;
import org.http4k.connect.model.Base64Blob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import se.ansman.kotshi.InternalKotshiApi;
import se.ansman.kotshi.KotshiUtils;
import se.ansman.kotshi.NamedJsonAdapter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/http4k/connect/amazon/kms/action/KotshiSignJsonAdapter;", "Lse/ansman/kotshi/NamedJsonAdapter;", "Lorg/http4k/connect/amazon/kms/action/Sign;", "moshi", "Lcom/squareup/moshi/Moshi;", "(Lcom/squareup/moshi/Moshi;)V", "defaultConstructor", "Ljava/lang/reflect/Constructor;", "keyIdAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lorg/http4k/connect/amazon/core/model/KMSKeyId;", "messageAdapter", "Lorg/http4k/connect/model/Base64Blob;", "options", "Lcom/squareup/moshi/JsonReader$Options;", "requestAdapter", "", "", "signingAlgorithmAdapter", "Lorg/http4k/connect/amazon/kms/model/SigningAlgorithm;", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "http4k-connect-amazon-kms"})
@InternalKotshiApi
@SourceDebugExtension(value={"SMAP\nKotshiSignJsonAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotshiSignJsonAdapter.kt\norg/http4k/connect/amazon/kms/action/KotshiSignJsonAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
public final class KotshiSignJsonAdapter
extends NamedJsonAdapter<Sign> {
    @NotNull
    private final JsonAdapter<KMSKeyId> keyIdAdapter;
    @NotNull
    private final JsonAdapter<Base64Blob> messageAdapter;
    @NotNull
    private final JsonAdapter<SigningAlgorithm> signingAlgorithmAdapter;
    @NotNull
    private final JsonAdapter<List<String>> requestAdapter;
    @NotNull
    private final JsonReader.Options options;
    @Nullable
    private volatile Constructor<Sign> defaultConstructor;

    public KotshiSignJsonAdapter(@NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        super("KotshiJsonAdapter(Sign)");
        JsonAdapter jsonAdapter = moshi.adapter((Type)((Object)KMSKeyId.class), SetsKt.emptySet(), "KeyId");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter(\n      KMS\u2026etOf(),\n      \"KeyId\"\n  )");
        this.keyIdAdapter = jsonAdapter;
        JsonAdapter jsonAdapter2 = moshi.adapter((Type)((Object)Base64Blob.class), SetsKt.emptySet(), "Message");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter2, (String)"moshi.adapter(\n      Bas\u2026Of(),\n      \"Message\"\n  )");
        this.messageAdapter = jsonAdapter2;
        JsonAdapter jsonAdapter3 = moshi.adapter((Type)((Object)SigningAlgorithm.class), SetsKt.emptySet(), "SigningAlgorithm");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter3, (String)"moshi.adapter(\n      Sig\u2026   \"SigningAlgorithm\"\n  )");
        this.signingAlgorithmAdapter = jsonAdapter3;
        Object[] objectArray = new Type[]{String.class};
        JsonAdapter jsonAdapter4 = moshi.adapter((Type)Types.newParameterizedType((Type)((Type)((Object)List.class)), (Type[])objectArray), SetsKt.emptySet(), "Request");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter4, (String)"moshi.adapter(\n      new\u2026Of(),\n      \"Request\"\n  )");
        this.requestAdapter = jsonAdapter4;
        objectArray = new String[]{"KeyId", "Message", "SigningAlgorithm", "Request", "MessageType"};
        JsonReader.Options options = JsonReader.Options.of((String[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"of(\n      \"KeyId\",\n     \u2026,\n      \"MessageType\"\n  )");
        this.options = options;
    }

    public void toJson(@NotNull JsonWriter writer, @Nullable Sign value) throws IOException {
        JsonWriter jsonWriter;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (value == null) {
            writer.nullValue();
            return;
        }
        JsonWriter $this$toJson_u24lambda_u240 = jsonWriter = writer.beginObject().name("KeyId");
        boolean bl = false;
        this.keyIdAdapter.toJson($this$toJson_u24lambda_u240, (Object)value.getKeyId());
        JsonWriter $this$toJson_u24lambda_u241 = jsonWriter = jsonWriter.name("Message");
        boolean bl2 = false;
        this.messageAdapter.toJson($this$toJson_u24lambda_u241, (Object)value.getMessage());
        JsonWriter $this$toJson_u24lambda_u242 = jsonWriter = jsonWriter.name("SigningAlgorithm");
        boolean bl3 = false;
        this.signingAlgorithmAdapter.toJson($this$toJson_u24lambda_u242, (Object)value.getSigningAlgorithm());
        JsonWriter $this$toJson_u24lambda_u243 = jsonWriter = jsonWriter.name("Request");
        boolean bl4 = false;
        this.requestAdapter.toJson($this$toJson_u24lambda_u243, value.getRequest());
        jsonWriter.name("MessageType").value(value.getMessageType()).endObject();
    }

    @Nullable
    public Sign fromJson(@NotNull JsonReader reader) throws IOException {
        Sign sign;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Sign)((Object)reader.nextNull());
        }
        int mask = -1;
        KMSKeyId keyId = null;
        Base64Blob message = null;
        SigningAlgorithm signingAlgorithm = null;
        List request = null;
        String messageType = null;
        reader.beginObject();
        while (reader.hasNext()) {
            switch (reader.selectName(this.options)) {
                case 0: {
                    keyId = (KMSKeyId)this.keyIdAdapter.fromJson(reader);
                    break;
                }
                case 1: {
                    message = (Base64Blob)this.messageAdapter.fromJson(reader);
                    break;
                }
                case 2: {
                    signingAlgorithm = (SigningAlgorithm)((Object)this.signingAlgorithmAdapter.fromJson(reader));
                    break;
                }
                case 3: {
                    request = (List)this.requestAdapter.fromJson(reader);
                    mask &= 0xFFFFFFF7;
                    break;
                }
                case 4: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.skipValue();
                    } else {
                        messageType = reader.nextString();
                    }
                    mask &= 0xFFFFFFEF;
                    break;
                }
                case -1: {
                    reader.skipName();
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
        StringBuilder errorBuilder = null;
        if (keyId == null) {
            errorBuilder = KotshiUtils.appendNullableError$default(errorBuilder, (String)"KeyId", null, (int)2, null);
        }
        if (message == null) {
            errorBuilder = KotshiUtils.appendNullableError$default((StringBuilder)errorBuilder, (String)"Message", null, (int)2, null);
        }
        if (signingAlgorithm == null) {
            errorBuilder = KotshiUtils.appendNullableError$default((StringBuilder)errorBuilder, (String)"SigningAlgorithm", null, (int)2, null);
        }
        if (errorBuilder != null) {
            errorBuilder.append(" (at path ").append(reader.getPath()).append(')');
            throw new JsonDataException(errorBuilder.toString());
        }
        if (mask == -25) {
            KMSKeyId kMSKeyId = keyId;
            Intrinsics.checkNotNull((Object)kMSKeyId);
            Base64Blob base64Blob = message;
            Intrinsics.checkNotNull((Object)base64Blob);
            SigningAlgorithm signingAlgorithm2 = signingAlgorithm;
            Intrinsics.checkNotNull((Object)((Object)signingAlgorithm2));
            sign = new Sign(kMSKeyId, base64Blob, signingAlgorithm2, request, messageType);
        } else {
            Object object = this.defaultConstructor;
            if (this.defaultConstructor == null) {
                Object object2 = new Class[]{KMSKeyId.class, Base64Blob.class, SigningAlgorithm.class, List.class, String.class, Integer.TYPE, DefaultConstructorMarker.class};
                Object it = object2 = Sign.class.getDeclaredConstructor((Class<?>)object2);
                boolean bl = false;
                this.defaultConstructor = it;
                object = object2;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"Sign::class.java.getDecl\u2026defaultConstructor = it }");
            }
            Object localConstructor = object;
            Object[] objectArray = new Object[]{keyId, message, signingAlgorithm, request, messageType, mask, null};
            sign = localConstructor.newInstance(objectArray);
        }
        return sign;
    }
}

