// Code generated by Kotshi. Do not edit.
package org.http4k.connect.amazon.kms.action

import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.JsonDataException
import com.squareup.moshi.JsonReader
import com.squareup.moshi.JsonWriter
import com.squareup.moshi.Moshi
import java.io.IOException
import java.lang.StringBuilder
import kotlin.Unit
import kotlin.jvm.Throws
import org.http4k.connect.amazon.core.model.Base64Blob
import org.http4k.connect.amazon.core.model.KMSKeyId
import org.http4k.connect.amazon.kms.model.EncryptionAlgorithm
import se.ansman.kotshi.KotshiUtils
import se.ansman.kotshi.KotshiUtils.appendNullableError
import se.ansman.kotshi.NamedJsonAdapter

internal class KotshiEncryptedJsonAdapter(
  moshi: Moshi
) : NamedJsonAdapter<Encrypted>("KotshiJsonAdapter(Encrypted)") {
  private val kMSKeyIdAdapter: JsonAdapter<KMSKeyId> = moshi.adapter(KMSKeyId::class.javaObjectType)

  private val base64BlobAdapter: JsonAdapter<Base64Blob> =
      moshi.adapter(Base64Blob::class.javaObjectType)

  private val encryptionAlgorithmAdapter: JsonAdapter<EncryptionAlgorithm> =
      moshi.adapter(EncryptionAlgorithm::class.javaObjectType)

  private val options: JsonReader.Options = JsonReader.Options.of(
      "KeyId",
      "CiphertextBlob",
      "EncryptionAlgorithm"
  )

  @Throws(IOException::class)
  public override fun toJson(writer: JsonWriter, `value`: Encrypted?): Unit {
    if (`value` == null) {
      writer.nullValue()
      return
    }
    writer.beginObject()
    writer.name("KeyId")
    kMSKeyIdAdapter.toJson(writer, `value`.KeyId)
    writer.name("CiphertextBlob")
    base64BlobAdapter.toJson(writer, `value`.CiphertextBlob)
    writer.name("EncryptionAlgorithm")
    encryptionAlgorithmAdapter.toJson(writer, `value`.EncryptionAlgorithm)
    writer.endObject()
  }

  @Throws(IOException::class)
  public override fun fromJson(reader: JsonReader): Encrypted? {
    if (reader.peek() == JsonReader.Token.NULL) return reader.nextNull()

    var KeyId: KMSKeyId? = null
    var CiphertextBlob: Base64Blob? = null
    var EncryptionAlgorithm: EncryptionAlgorithm? = null

    reader.beginObject()
    while (reader.hasNext()) {
      when (reader.selectName(options)) {
        0 -> {
          KeyId = kMSKeyIdAdapter.fromJson(reader)
        }
        1 -> {
          CiphertextBlob = base64BlobAdapter.fromJson(reader)
        }
        2 -> {
          EncryptionAlgorithm = encryptionAlgorithmAdapter.fromJson(reader)
        }
        -1 -> {
          reader.skipName()
          reader.skipValue()
        }
      }
    }
    reader.endObject()

    var errorBuilder: StringBuilder? = null
    if (KeyId == null) {
      errorBuilder = errorBuilder.appendNullableError("KeyId")
    }
    if (CiphertextBlob == null) {
      errorBuilder = errorBuilder.appendNullableError("CiphertextBlob")
    }
    if (EncryptionAlgorithm == null) {
      errorBuilder = errorBuilder.appendNullableError("EncryptionAlgorithm")
    }
    if (errorBuilder != null) {
      errorBuilder.append(" (at path ").append(reader.path).append(')')
      throw JsonDataException(errorBuilder.toString())
    }

    return Encrypted(
        KeyId = KeyId!!,
        CiphertextBlob = CiphertextBlob!!,
        EncryptionAlgorithm = EncryptionAlgorithm!!
    )
  }
}
