/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.kms.action;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.connect.amazon.core.model.KMSKeyId;
import org.http4k.connect.amazon.kms.action.Decrypt;
import org.http4k.connect.amazon.kms.model.EncryptionAlgorithm;
import org.http4k.connect.model.Base64Blob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import se.ansman.kotshi.InternalKotshiApi;
import se.ansman.kotshi.KotshiUtils;
import se.ansman.kotshi.NamedJsonAdapter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0002H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00110\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/http4k/connect/amazon/kms/action/KotshiDecryptJsonAdapter;", "Lse/ansman/kotshi/NamedJsonAdapter;", "Lorg/http4k/connect/amazon/kms/action/Decrypt;", "moshi", "Lcom/squareup/moshi/Moshi;", "(Lcom/squareup/moshi/Moshi;)V", "ciphertextBlobAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lorg/http4k/connect/model/Base64Blob;", "defaultConstructor", "Ljava/lang/reflect/Constructor;", "encryptionAlgorithmAdapter", "Lorg/http4k/connect/amazon/kms/model/EncryptionAlgorithm;", "encryptionContextAdapter", "", "", "grantTokensAdapter", "", "keyIdAdapter", "Lorg/http4k/connect/amazon/core/model/KMSKeyId;", "options", "Lcom/squareup/moshi/JsonReader$Options;", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "http4k-connect-amazon-kms"})
@InternalKotshiApi
@SourceDebugExtension(value={"SMAP\nKotshiDecryptJsonAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotshiDecryptJsonAdapter.kt\norg/http4k/connect/amazon/kms/action/KotshiDecryptJsonAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1#2:204\n*E\n"})
public final class KotshiDecryptJsonAdapter
extends NamedJsonAdapter<Decrypt> {
    @NotNull
    private final JsonAdapter<KMSKeyId> keyIdAdapter;
    @NotNull
    private final JsonAdapter<Base64Blob> ciphertextBlobAdapter;
    @NotNull
    private final JsonAdapter<EncryptionAlgorithm> encryptionAlgorithmAdapter;
    @NotNull
    private final JsonAdapter<Map<String, String>> encryptionContextAdapter;
    @NotNull
    private final JsonAdapter<List<String>> grantTokensAdapter;
    @NotNull
    private final JsonReader.Options options;
    @Nullable
    private volatile Constructor<Decrypt> defaultConstructor;

    public KotshiDecryptJsonAdapter(@NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        super("KotshiJsonAdapter(Decrypt)");
        JsonAdapter jsonAdapter = moshi.adapter((Type)((Object)KMSKeyId.class), SetsKt.emptySet(), "KeyId");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
        this.keyIdAdapter = jsonAdapter;
        JsonAdapter jsonAdapter2 = moshi.adapter((Type)((Object)Base64Blob.class), SetsKt.emptySet(), "CiphertextBlob");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter2, (String)"adapter(...)");
        this.ciphertextBlobAdapter = jsonAdapter2;
        JsonAdapter jsonAdapter3 = moshi.adapter((Type)((Object)EncryptionAlgorithm.class), SetsKt.emptySet(), "EncryptionAlgorithm");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter3, (String)"adapter(...)");
        this.encryptionAlgorithmAdapter = jsonAdapter3;
        Object[] objectArray = new Type[]{String.class, String.class};
        JsonAdapter jsonAdapter4 = moshi.adapter((Type)Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])objectArray), SetsKt.emptySet(), "EncryptionContext");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter4, (String)"adapter(...)");
        this.encryptionContextAdapter = jsonAdapter4;
        objectArray = new Type[]{String.class};
        JsonAdapter jsonAdapter5 = moshi.adapter((Type)Types.newParameterizedType((Type)((Type)((Object)List.class)), (Type[])objectArray), SetsKt.emptySet(), "GrantTokens");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter5, (String)"adapter(...)");
        this.grantTokensAdapter = jsonAdapter5;
        objectArray = new String[]{"KeyId", "CiphertextBlob", "EncryptionAlgorithm", "EncryptionContext", "GrantTokens"};
        JsonReader.Options options = JsonReader.Options.of((String[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"of(...)");
        this.options = options;
    }

    public void toJson(@NotNull JsonWriter writer, @Nullable Decrypt value) throws IOException {
        JsonWriter jsonWriter;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (value == null) {
            writer.nullValue();
            return;
        }
        JsonWriter $this$toJson_u24lambda_u240 = jsonWriter = writer.beginObject().name("KeyId");
        boolean bl = false;
        this.keyIdAdapter.toJson($this$toJson_u24lambda_u240, (Object)value.getKeyId());
        JsonWriter $this$toJson_u24lambda_u241 = jsonWriter = jsonWriter.name("CiphertextBlob");
        boolean bl2 = false;
        this.ciphertextBlobAdapter.toJson($this$toJson_u24lambda_u241, (Object)value.getCiphertextBlob());
        JsonWriter $this$toJson_u24lambda_u242 = jsonWriter = jsonWriter.name("EncryptionAlgorithm");
        boolean bl3 = false;
        this.encryptionAlgorithmAdapter.toJson($this$toJson_u24lambda_u242, (Object)value.getEncryptionAlgorithm());
        JsonWriter $this$toJson_u24lambda_u243 = jsonWriter = jsonWriter.name("EncryptionContext");
        boolean bl4 = false;
        this.encryptionContextAdapter.toJson($this$toJson_u24lambda_u243, value.getEncryptionContext());
        JsonWriter $this$toJson_u24lambda_u244 = jsonWriter = jsonWriter.name("GrantTokens");
        boolean bl5 = false;
        this.grantTokensAdapter.toJson($this$toJson_u24lambda_u244, value.getGrantTokens());
        jsonWriter.endObject();
    }

    @Nullable
    public Decrypt fromJson(@NotNull JsonReader reader) throws IOException {
        Decrypt decrypt;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Decrypt)((Object)reader.nextNull());
        }
        int mask = -1;
        KMSKeyId keyId = null;
        Base64Blob ciphertextBlob = null;
        EncryptionAlgorithm encryptionAlgorithm = null;
        Map encryptionContext = null;
        List grantTokens = null;
        reader.beginObject();
        while (reader.hasNext()) {
            switch (reader.selectName(this.options)) {
                case 0: {
                    keyId = (KMSKeyId)this.keyIdAdapter.fromJson(reader);
                    break;
                }
                case 1: {
                    ciphertextBlob = (Base64Blob)this.ciphertextBlobAdapter.fromJson(reader);
                    break;
                }
                case 2: {
                    encryptionAlgorithm = (EncryptionAlgorithm)((Object)this.encryptionAlgorithmAdapter.fromJson(reader));
                    mask &= 0xFFFFFFFB;
                    break;
                }
                case 3: {
                    encryptionContext = (Map)this.encryptionContextAdapter.fromJson(reader);
                    mask &= 0xFFFFFFF7;
                    break;
                }
                case 4: {
                    grantTokens = (List)this.grantTokensAdapter.fromJson(reader);
                    mask &= 0xFFFFFFEF;
                    break;
                }
                case -1: {
                    reader.skipName();
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
        StringBuilder errorBuilder = null;
        if (keyId == null) {
            errorBuilder = KotshiUtils.appendNullableError$default(errorBuilder, (String)"KeyId", null, (int)2, null);
        }
        if (ciphertextBlob == null) {
            errorBuilder = KotshiUtils.appendNullableError$default((StringBuilder)errorBuilder, (String)"CiphertextBlob", null, (int)2, null);
        }
        if (errorBuilder != null) {
            errorBuilder.append(" (at path ").append(reader.getPath()).append(')');
            throw new JsonDataException(errorBuilder.toString());
        }
        if (mask == -29) {
            KMSKeyId kMSKeyId = keyId;
            Intrinsics.checkNotNull((Object)kMSKeyId);
            Base64Blob base64Blob = ciphertextBlob;
            Intrinsics.checkNotNull((Object)base64Blob);
            decrypt = new Decrypt(kMSKeyId, base64Blob, encryptionAlgorithm, encryptionContext, grantTokens);
        } else {
            Object object = this.defaultConstructor;
            if (this.defaultConstructor == null) {
                Object object2 = new Class[]{KMSKeyId.class, Base64Blob.class, EncryptionAlgorithm.class, Map.class, List.class, Integer.TYPE, DefaultConstructorMarker.class};
                Object it = object2 = Decrypt.class.getDeclaredConstructor((Class<?>)object2);
                boolean bl = false;
                this.defaultConstructor = it;
                object = object2;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            }
            Object localConstructor = object;
            Object[] objectArray = new Object[]{keyId, ciphertextBlob, encryptionAlgorithm, encryptionContext, grantTokens, mask, null};
            decrypt = localConstructor.newInstance(objectArray);
        }
        return decrypt;
    }
}

