package org.http4k.connect.amazon.kms

import dev.forkhandles.result4k.Result
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.sequences.Sequence
import org.http4k.connect.RemoteFailure
import org.http4k.connect.amazon.core.model.KMSKeyId
import org.http4k.connect.amazon.core.model.Tag
import org.http4k.connect.amazon.kms.action.CreateKey
import org.http4k.connect.amazon.kms.action.Decrypt
import org.http4k.connect.amazon.kms.action.Decrypted
import org.http4k.connect.amazon.kms.action.DescribeKey
import org.http4k.connect.amazon.kms.action.Encrypt
import org.http4k.connect.amazon.kms.action.Encrypted
import org.http4k.connect.amazon.kms.action.GetPublicKey
import org.http4k.connect.amazon.kms.action.KeyCreated
import org.http4k.connect.amazon.kms.action.KeyDeletionSchedule
import org.http4k.connect.amazon.kms.action.KeyDescription
import org.http4k.connect.amazon.kms.action.KeyList
import org.http4k.connect.amazon.kms.action.ListKeys
import org.http4k.connect.amazon.kms.action.PublicKey
import org.http4k.connect.amazon.kms.action.ScheduleKeyDeletion
import org.http4k.connect.amazon.kms.action.Sign
import org.http4k.connect.amazon.kms.action.Signed
import org.http4k.connect.amazon.kms.action.Verify
import org.http4k.connect.amazon.kms.action.VerifyResult
import org.http4k.connect.amazon.kms.model.CustomerMasterKeySpec
import org.http4k.connect.amazon.kms.model.EncryptionAlgorithm
import org.http4k.connect.amazon.kms.model.KeyEntry
import org.http4k.connect.amazon.kms.model.KeyUsage
import org.http4k.connect.amazon.kms.model.SigningAlgorithm
import org.http4k.connect.model.Base64Blob

/**
 * @see org.http4k.connect.amazon.kms.action.CreateKey
 */
public fun KMS.createKey(
  CustomerMasterKeySpec: CustomerMasterKeySpec? = null,
  KeyUsage: KeyUsage? = null,
  KeySpec: CustomerMasterKeySpec? = null,
  BypassPolicyLockoutSafetyCheck: Boolean? = null,
  CustomKeyStoreId: String? = null,
  Description: String? = null,
  Origin: String? = null,
  Policy: String? = null,
  Tags: List<Tag>? = null,
): Result<KeyCreated, RemoteFailure> = invoke(CreateKey(CustomerMasterKeySpec, KeyUsage, KeySpec,
    BypassPolicyLockoutSafetyCheck, CustomKeyStoreId, Description, Origin, Policy, Tags))

/**
 * @see org.http4k.connect.amazon.kms.action.Decrypt
 */
public fun KMS.decrypt(
  KeyId: KMSKeyId,
  CiphertextBlob: Base64Blob,
  EncryptionAlgorithm: EncryptionAlgorithm? = null,
  EncryptionContext: Map<String, String>? = null,
  GrantTokens: List<String>? = null,
): Result<Decrypted, RemoteFailure> = invoke(Decrypt(KeyId, CiphertextBlob, EncryptionAlgorithm,
    EncryptionContext, GrantTokens))

/**
 * @see org.http4k.connect.amazon.kms.action.DescribeKey
 */
public fun KMS.describeKey(KeyId: KMSKeyId, GrantTokens: List<String>? = null):
    Result<KeyDescription, RemoteFailure> = invoke(DescribeKey(KeyId, GrantTokens))

/**
 * @see org.http4k.connect.amazon.kms.action.Encrypt
 */
public fun KMS.encrypt(
  KeyId: KMSKeyId,
  Plaintext: Base64Blob,
  EncryptionAlgorithm: EncryptionAlgorithm? = null,
  EncryptionContext: Map<String, String>? = null,
  GrantTokens: List<String>? = null,
): Result<Encrypted, RemoteFailure> = invoke(Encrypt(KeyId, Plaintext, EncryptionAlgorithm,
    EncryptionContext, GrantTokens))

/**
 * @see org.http4k.connect.amazon.kms.action.GetPublicKey
 */
public fun KMS.getPublicKey(KeyId: KMSKeyId, GrantTokens: List<String>? = null):
    Result<PublicKey, RemoteFailure> = invoke(GetPublicKey(KeyId, GrantTokens))

/**
 * @see org.http4k.connect.amazon.kms.action.ListKeys
 */
public fun KMS.listKeys(Limit: Int? = null, Marker: String? = null): Result<KeyList, RemoteFailure>
    = invoke(ListKeys(Limit, Marker))

/**
 * @see org.http4k.connect.amazon.kms.action.ListKeys
 */
public fun KMS.listKeysPaginated(Limit: Int? = null, Marker: String? = null):
    Sequence<Result<List<KeyEntry>, RemoteFailure>> = org.http4k.connect.paginated(::invoke,
    ListKeys(Limit, Marker))

/**
 * @see org.http4k.connect.amazon.kms.action.ScheduleKeyDeletion
 */
public fun KMS.scheduleKeyDeletion(KeyId: KMSKeyId, PendingWindowInDays: Int? = null):
    Result<KeyDeletionSchedule, RemoteFailure> = invoke(ScheduleKeyDeletion(KeyId,
    PendingWindowInDays))

/**
 * @see org.http4k.connect.amazon.kms.action.Sign
 */
public fun KMS.sign(
  KeyId: KMSKeyId,
  Message: Base64Blob,
  SigningAlgorithm: SigningAlgorithm,
  Request: List<String>? = null,
  MessageType: String? = null,
): Result<Signed, RemoteFailure> = invoke(Sign(KeyId, Message, SigningAlgorithm, Request,
    MessageType))

/**
 * @see org.http4k.connect.amazon.kms.action.Verify
 */
public fun KMS.verify(
  KeyId: KMSKeyId,
  Message: Base64Blob,
  Signature: Base64Blob,
  SigningAlgorithm: SigningAlgorithm,
  MessageType: String? = null,
  GrantTokens: List<String>? = null,
): Result<VerifyResult, RemoteFailure> = invoke(Verify(KeyId, Message, Signature, SigningAlgorithm,
    MessageType, GrantTokens))
