/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.kms.action;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.connect.amazon.core.model.KMSKeyId;
import org.http4k.connect.amazon.kms.action.Encrypt;
import org.http4k.connect.amazon.kms.model.EncryptionAlgorithm;
import org.http4k.connect.model.Base64Blob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import se.ansman.kotshi.InternalKotshiApi;
import se.ansman.kotshi.KotshiUtils;
import se.ansman.kotshi.NamedJsonAdapter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00120\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/http4k/connect/amazon/kms/action/KotshiEncryptJsonAdapter;", "Lse/ansman/kotshi/NamedJsonAdapter;", "Lorg/http4k/connect/amazon/kms/action/Encrypt;", "moshi", "Lcom/squareup/moshi/Moshi;", "<init>", "(Lcom/squareup/moshi/Moshi;)V", "keyIdAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lorg/http4k/connect/amazon/core/model/KMSKeyId;", "plaintextAdapter", "Lorg/http4k/connect/model/Base64Blob;", "encryptionAlgorithmAdapter", "Lorg/http4k/connect/amazon/kms/model/EncryptionAlgorithm;", "encryptionContextAdapter", "", "", "grantTokensAdapter", "", "options", "Lcom/squareup/moshi/JsonReader$Options;", "defaultConstructor", "Ljava/lang/reflect/Constructor;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "http4k-connect-amazon-kms"})
@InternalKotshiApi
@SourceDebugExtension(value={"SMAP\nKotshiEncryptJsonAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotshiEncryptJsonAdapter.kt\norg/http4k/connect/amazon/kms/action/KotshiEncryptJsonAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public final class KotshiEncryptJsonAdapter
extends NamedJsonAdapter<Encrypt> {
    @NotNull
    private final JsonAdapter<KMSKeyId> keyIdAdapter;
    @NotNull
    private final JsonAdapter<Base64Blob> plaintextAdapter;
    @NotNull
    private final JsonAdapter<EncryptionAlgorithm> encryptionAlgorithmAdapter;
    @NotNull
    private final JsonAdapter<Map<String, String>> encryptionContextAdapter;
    @NotNull
    private final JsonAdapter<List<String>> grantTokensAdapter;
    @NotNull
    private final JsonReader.Options options;
    @Nullable
    private volatile Constructor<Encrypt> defaultConstructor;

    public KotshiEncryptJsonAdapter(@NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        super("KotshiJsonAdapter(Encrypt)");
        JsonAdapter jsonAdapter = moshi.adapter((Type)((Object)KMSKeyId.class), SetsKt.emptySet(), "KeyId");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
        this.keyIdAdapter = jsonAdapter;
        JsonAdapter jsonAdapter2 = moshi.adapter((Type)((Object)Base64Blob.class), SetsKt.emptySet(), "Plaintext");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter2, (String)"adapter(...)");
        this.plaintextAdapter = jsonAdapter2;
        JsonAdapter jsonAdapter3 = moshi.adapter((Type)((Object)EncryptionAlgorithm.class), SetsKt.emptySet(), "EncryptionAlgorithm");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter3, (String)"adapter(...)");
        this.encryptionAlgorithmAdapter = jsonAdapter3;
        Object[] objectArray = new Type[]{String.class, String.class};
        JsonAdapter jsonAdapter4 = moshi.adapter((Type)Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])objectArray), SetsKt.emptySet(), "EncryptionContext");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter4, (String)"adapter(...)");
        this.encryptionContextAdapter = jsonAdapter4;
        objectArray = new Type[]{String.class};
        JsonAdapter jsonAdapter5 = moshi.adapter((Type)Types.newParameterizedType((Type)((Type)((Object)List.class)), (Type[])objectArray), SetsKt.emptySet(), "GrantTokens");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter5, (String)"adapter(...)");
        this.grantTokensAdapter = jsonAdapter5;
        objectArray = new String[]{"KeyId", "Plaintext", "EncryptionAlgorithm", "EncryptionContext", "GrantTokens"};
        JsonReader.Options options = JsonReader.Options.of((String[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"of(...)");
        this.options = options;
    }

    public void toJson(@NotNull JsonWriter writer, @Nullable Encrypt value) throws IOException {
        JsonWriter jsonWriter;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (value == null) {
            writer.nullValue();
            return;
        }
        JsonWriter $this$toJson_u24lambda_u240 = jsonWriter = writer.beginObject().name("KeyId");
        boolean bl = false;
        this.keyIdAdapter.toJson($this$toJson_u24lambda_u240, (Object)value.getKeyId());
        JsonWriter $this$toJson_u24lambda_u241 = jsonWriter = jsonWriter.name("Plaintext");
        boolean bl2 = false;
        this.plaintextAdapter.toJson($this$toJson_u24lambda_u241, (Object)value.getPlaintext());
        JsonWriter $this$toJson_u24lambda_u242 = jsonWriter = jsonWriter.name("EncryptionAlgorithm");
        boolean bl3 = false;
        this.encryptionAlgorithmAdapter.toJson($this$toJson_u24lambda_u242, (Object)value.getEncryptionAlgorithm());
        JsonWriter $this$toJson_u24lambda_u243 = jsonWriter = jsonWriter.name("EncryptionContext");
        boolean bl4 = false;
        this.encryptionContextAdapter.toJson($this$toJson_u24lambda_u243, value.getEncryptionContext());
        JsonWriter $this$toJson_u24lambda_u244 = jsonWriter = jsonWriter.name("GrantTokens");
        boolean bl5 = false;
        this.grantTokensAdapter.toJson($this$toJson_u24lambda_u244, value.getGrantTokens());
        jsonWriter.endObject();
    }

    @Nullable
    public Encrypt fromJson(@NotNull JsonReader reader) throws IOException {
        Encrypt encrypt;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Encrypt)((Object)reader.nextNull());
        }
        int mask = -1;
        KMSKeyId keyId = null;
        Base64Blob plaintext = null;
        EncryptionAlgorithm encryptionAlgorithm = null;
        Map encryptionContext = null;
        List grantTokens = null;
        reader.beginObject();
        while (reader.hasNext()) {
            switch (reader.selectName(this.options)) {
                case 0: {
                    keyId = (KMSKeyId)this.keyIdAdapter.fromJson(reader);
                    break;
                }
                case 1: {
                    plaintext = (Base64Blob)this.plaintextAdapter.fromJson(reader);
                    break;
                }
                case 2: {
                    encryptionAlgorithm = (EncryptionAlgorithm)((Object)this.encryptionAlgorithmAdapter.fromJson(reader));
                    mask &= 0xFFFFFFFB;
                    break;
                }
                case 3: {
                    encryptionContext = (Map)this.encryptionContextAdapter.fromJson(reader);
                    mask &= 0xFFFFFFF7;
                    break;
                }
                case 4: {
                    grantTokens = (List)this.grantTokensAdapter.fromJson(reader);
                    mask &= 0xFFFFFFEF;
                    break;
                }
                case -1: {
                    reader.skipName();
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
        StringBuilder errorBuilder = null;
        if (keyId == null) {
            errorBuilder = KotshiUtils.appendNullableError$default(errorBuilder, (String)"KeyId", null, (int)2, null);
        }
        if (plaintext == null) {
            errorBuilder = KotshiUtils.appendNullableError$default((StringBuilder)errorBuilder, (String)"Plaintext", null, (int)2, null);
        }
        if (errorBuilder != null) {
            errorBuilder.append(" (at path ").append(reader.getPath()).append(')');
            throw new JsonDataException(errorBuilder.toString());
        }
        if (mask == -29) {
            KMSKeyId kMSKeyId = keyId;
            Intrinsics.checkNotNull((Object)kMSKeyId);
            Base64Blob base64Blob = plaintext;
            Intrinsics.checkNotNull((Object)base64Blob);
            encrypt = new Encrypt(kMSKeyId, base64Blob, encryptionAlgorithm, encryptionContext, grantTokens);
        } else {
            Object object = this.defaultConstructor;
            if (this.defaultConstructor == null) {
                Object object2 = new Class[]{KMSKeyId.class, Base64Blob.class, EncryptionAlgorithm.class, Map.class, List.class, Integer.TYPE, DefaultConstructorMarker.class};
                Object it = object2 = Encrypt.class.getDeclaredConstructor((Class<?>)object2);
                boolean bl = false;
                this.defaultConstructor = it;
                object = object2;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            }
            Object localConstructor = object;
            Object[] objectArray = new Object[]{keyId, plaintext, encryptionAlgorithm, encryptionContext, grantTokens, mask, null};
            encrypt = localConstructor.newInstance(objectArray);
        }
        return encrypt;
    }
}

