// Code generated by Kotshi. Do not edit.
package org.http4k.connect.amazon.kms.action

import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.JsonDataException
import com.squareup.moshi.JsonReader
import com.squareup.moshi.JsonWriter
import com.squareup.moshi.Moshi
import com.squareup.moshi.Types.newParameterizedType
import java.io.IOException
import java.lang.StringBuilder
import java.lang.reflect.Constructor
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.apply
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.collections.setOf
import kotlin.jvm.Throws
import kotlin.jvm.Volatile
import kotlin.jvm.`internal`.DefaultConstructorMarker
import org.http4k.connect.amazon.core.model.KMSKeyId
import org.http4k.connect.amazon.kms.model.EncryptionAlgorithm
import org.http4k.connect.model.Base64Blob
import se.ansman.kotshi.InternalKotshiApi
import se.ansman.kotshi.KotshiUtils.appendNullableError
import se.ansman.kotshi.NamedJsonAdapter

@InternalKotshiApi
@Suppress(
  "DEPRECATION",
  "unused",
  "ClassName",
  "REDUNDANT_PROJECTION",
  "RedundantExplicitType",
  "LocalVariableName",
  "RedundantVisibilityModifier",
  "PLATFORM_CLASS_MAPPED_TO_KOTLIN",
  "IMPLICIT_NOTHING_TYPE_ARGUMENT_IN_RETURN_POSITION",
  "EXPERIMENTAL_API_USAGE",
  "OPT_IN_USAGE",
)
internal class KotshiEncryptJsonAdapter(
  moshi: Moshi,
) : NamedJsonAdapter<Encrypt>("KotshiJsonAdapter(Encrypt)") {
  private val keyIdAdapter: JsonAdapter<KMSKeyId> = moshi.adapter(
      KMSKeyId::class.javaObjectType,
      setOf(),
      "KeyId"
  )

  private val plaintextAdapter: JsonAdapter<Base64Blob> = moshi.adapter(
      Base64Blob::class.javaObjectType,
      setOf(),
      "Plaintext"
  )

  private val encryptionAlgorithmAdapter: JsonAdapter<EncryptionAlgorithm?> = moshi.adapter(
      EncryptionAlgorithm::class.javaObjectType,
      setOf(),
      "EncryptionAlgorithm"
  )

  private val encryptionContextAdapter: JsonAdapter<Map<String, String>?> = moshi.adapter(
      newParameterizedType(Map::class.javaObjectType, String::class.javaObjectType, String::class.javaObjectType),
      setOf(),
      "EncryptionContext"
  )

  private val grantTokensAdapter: JsonAdapter<List<String>?> = moshi.adapter(
      newParameterizedType(List::class.javaObjectType, String::class.javaObjectType),
      setOf(),
      "GrantTokens"
  )

  private val options: JsonReader.Options = JsonReader.Options.of(
      "KeyId",
      "Plaintext",
      "EncryptionAlgorithm",
      "EncryptionContext",
      "GrantTokens"
  )

  @Volatile
  private var defaultConstructor: Constructor<Encrypt>? = null

  @Throws(IOException::class)
  override fun toJson(writer: JsonWriter, `value`: Encrypt?) {
    if (`value` == null) {
      writer.nullValue()
      return
    }
    writer
      .beginObject()
      .name("KeyId").apply {
        keyIdAdapter.toJson(this, `value`.KeyId)
      }
      .name("Plaintext").apply {
        plaintextAdapter.toJson(this, `value`.Plaintext)
      }
      .name("EncryptionAlgorithm").apply {
        encryptionAlgorithmAdapter.toJson(this, `value`.EncryptionAlgorithm)
      }
      .name("EncryptionContext").apply {
        encryptionContextAdapter.toJson(this, `value`.EncryptionContext)
      }
      .name("GrantTokens").apply {
        grantTokensAdapter.toJson(this, `value`.GrantTokens)
      }
      .endObject()
  }

  @Throws(IOException::class)
  override fun fromJson(reader: JsonReader): Encrypt? {
    if (reader.peek() == JsonReader.Token.NULL) return reader.nextNull()

    var mask = -1
    var keyId: KMSKeyId? = null
    var plaintext: Base64Blob? = null
    var encryptionAlgorithm: EncryptionAlgorithm? = null
    var encryptionContext: Map<String, String>? = null
    var grantTokens: List<String>? = null

    reader.beginObject()
    while (reader.hasNext()) {
      when (reader.selectName(options)) {
        0 -> {
          keyId = keyIdAdapter.fromJson(reader)
        }
        1 -> {
          plaintext = plaintextAdapter.fromJson(reader)
        }
        2 -> {
          encryptionAlgorithm = encryptionAlgorithmAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 2).inv()
          mask = mask and 0xfffffffb.toInt()
        }
        3 -> {
          encryptionContext = encryptionContextAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 3).inv()
          mask = mask and 0xfffffff7.toInt()
        }
        4 -> {
          grantTokens = grantTokensAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 4).inv()
          mask = mask and 0xffffffef.toInt()
        }
        -1 -> {
          reader.skipName()
          reader.skipValue()
        }
      }
    }
    reader.endObject()

    var errorBuilder: StringBuilder? = null
    if (keyId == null) {
      errorBuilder = errorBuilder.appendNullableError("KeyId")
    }
    if (plaintext == null) {
      errorBuilder = errorBuilder.appendNullableError("Plaintext")
    }
    if (errorBuilder != null) {
      errorBuilder.append(" (at path ").append(reader.path).append(')')
      throw JsonDataException(errorBuilder.toString())
    }

    return if (mask == 0xffffffe3.toInt()) {
      Encrypt(
          KeyId = keyId!!,
          Plaintext = plaintext!!,
          EncryptionAlgorithm = encryptionAlgorithm,
          EncryptionContext = encryptionContext,
          GrantTokens = grantTokens
      )
    } else {
      // Reflectively invoke the synthetic defaults constructor
      @Suppress("UNCHECKED_CAST")
      val localConstructor: Constructor<Encrypt> =
          this.defaultConstructor ?: Encrypt::class.java.getDeclaredConstructor(
            KMSKeyId::class.java,
            Base64Blob::class.java,
            EncryptionAlgorithm::class.java,
            Map::class.java,
            List::class.java,
            Int::class.javaPrimitiveType,
            DefaultConstructorMarker::class.java
          ).also { this.defaultConstructor = it }
      localConstructor.newInstance(
          keyId,
          plaintext,
          encryptionAlgorithm,
          encryptionContext,
          grantTokens,
          mask,
          /* DefaultConstructorMarker */ null
      )
    }
  }
}
