package org.http4k.connect.amazon.s3

import java.io.InputStream
import org.http4k.connect.amazon.model.BucketKey
import org.http4k.connect.amazon.model.BucketName
import org.http4k.connect.amazon.s3.action.CopyKey
import org.http4k.connect.amazon.s3.action.DeleteBucket
import org.http4k.connect.amazon.s3.action.DeleteKey
import org.http4k.connect.amazon.s3.action.GetKey
import org.http4k.connect.amazon.s3.action.ListKeys
import org.http4k.connect.amazon.s3.action.PutKey

/**
 * @see org.http4k.connect.amazon.s3.action.DeleteBucket
 */
public fun S3Bucket.deleteBucket() = this(DeleteBucket())

/**
 * @see org.http4k.connect.amazon.s3.action.DeleteKey
 */
public fun S3Bucket.deleteKey(key: BucketKey) = this(DeleteKey(key))

/**
 * @see org.http4k.connect.amazon.s3.action.GetKey
 */
public fun S3Bucket.getKey(key: BucketKey) = this(GetKey(key))

/**
 * @see org.http4k.connect.amazon.s3.action.ListKeys
 */
public fun S3Bucket.listKeys() = this(ListKeys())

/**
 * @see org.http4k.connect.amazon.s3.action.CopyKey
 */
public fun S3Bucket.copyKey(
  sourceBucket: BucketName,
  source: BucketKey,
  destination: BucketKey
) = this(CopyKey(sourceBucket, source, destination))

/**
 * @see org.http4k.connect.amazon.s3.action.PutKey
 */
public fun S3Bucket.putKey(key: BucketKey, content: InputStream) = this(PutKey(key, content))
