package org.http4k.connect.amazon.s3

import org.http4k.connect.amazon.model.BucketName
import org.http4k.connect.amazon.model.Region
import org.http4k.connect.amazon.s3.action.CreateBucket
import org.http4k.connect.amazon.s3.action.ListBuckets

/**
 * @see org.http4k.connect.amazon.s3.action.CreateBucket
 */
public fun S3.createBucket(bucketName: BucketName, region: Region) = invoke(CreateBucket(bucketName,
    region))

/**
 * @see org.http4k.connect.amazon.s3.action.ListBuckets
 */
public fun S3.listBuckets() = invoke(ListBuckets())
