package org.http4k.connect.amazon.s3

import java.io.InputStream
import kotlin.Int
import kotlin.String
import org.http4k.connect.amazon.model.BucketKey
import org.http4k.connect.amazon.model.BucketName
import org.http4k.connect.amazon.s3.action.CopyKey
import org.http4k.connect.amazon.s3.action.DeleteBucket
import org.http4k.connect.amazon.s3.action.DeleteKey
import org.http4k.connect.amazon.s3.action.GetKey
import org.http4k.connect.amazon.s3.action.ListObjectsV2
import org.http4k.connect.amazon.s3.action.PutKey

/**
 * @see org.http4k.connect.amazon.s3.action.DeleteBucket
 */
public fun S3Bucket.deleteBucket() = invoke(DeleteBucket())

/**
 * @see org.http4k.connect.amazon.s3.action.DeleteKey
 */
public fun S3Bucket.deleteKey(key: BucketKey) = invoke(DeleteKey(key))

/**
 * @see org.http4k.connect.amazon.s3.action.GetKey
 */
public fun S3Bucket.getKey(key: BucketKey) = invoke(GetKey(key))

/**
 * @see org.http4k.connect.amazon.s3.action.ListObjectsV2
 */
public fun S3Bucket.listObjectsV2(
  continuationToken: String? = null,
  maxKeys: Int? = null,
  prefix: String? = null,
  delimiter: String? = null,
  encodingType: String? = null,
  expectedBucketOwner: String? = null,
  requestPayer: String? = null
) = invoke(ListObjectsV2(continuationToken, maxKeys, prefix, delimiter, encodingType,
    expectedBucketOwner, requestPayer))

/**
 * @see org.http4k.connect.amazon.s3.action.ListObjectsV2
 */
public fun S3Bucket.listObjectsV2Paginated(
  continuationToken: String? = null,
  maxKeys: Int? = null,
  prefix: String? = null,
  delimiter: String? = null,
  encodingType: String? = null,
  expectedBucketOwner: String? = null,
  requestPayer: String? = null
) = org.http4k.connect.paginated(::invoke, ListObjectsV2(continuationToken, maxKeys, prefix,
    delimiter, encodingType, expectedBucketOwner, requestPayer))

/**
 * @see org.http4k.connect.amazon.s3.action.CopyKey
 */
public fun S3Bucket.copyKey(
  sourceBucket: BucketName,
  source: BucketKey,
  destination: BucketKey
) = invoke(CopyKey(sourceBucket, source, destination))

/**
 * @see org.http4k.connect.amazon.s3.action.PutKey
 */
public fun S3Bucket.putKey(key: BucketKey, content: InputStream) = invoke(PutKey(key, content))
