package org.http4k.connect.amazon.s3

import java.io.InputStream
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.collections.List
import org.http4k.connect.amazon.s3.action.CopyObject
import org.http4k.connect.amazon.s3.action.DeleteBucket
import org.http4k.connect.amazon.s3.action.DeleteObject
import org.http4k.connect.amazon.s3.action.GetObject
import org.http4k.connect.amazon.s3.action.ListObjectsV2
import org.http4k.connect.amazon.s3.action.PutObject
import org.http4k.connect.amazon.s3.model.BucketKey
import org.http4k.connect.amazon.s3.model.BucketName

/**
 * @see org.http4k.connect.amazon.s3.action.DeleteBucket
 */
public fun S3Bucket.deleteBucket() = invoke(DeleteBucket())

/**
 * @see org.http4k.connect.amazon.s3.action.PutObject
 */
public fun S3Bucket.putObject(
  key: BucketKey,
  content: InputStream,
  headers: List<Pair<String, String?>>
) = invoke(PutObject(key, content, headers))

/**
 * @see org.http4k.connect.amazon.s3.action.ListObjectsV2
 */
public fun S3Bucket.listObjectsV2(
  continuationToken: String? = null,
  maxKeys: Int? = null,
  prefix: String? = null,
  delimiter: String? = null,
  encodingType: String? = null,
  expectedBucketOwner: String? = null,
  requestPayer: String? = null
) = invoke(ListObjectsV2(continuationToken, maxKeys, prefix, delimiter, encodingType,
    expectedBucketOwner, requestPayer))

/**
 * @see org.http4k.connect.amazon.s3.action.ListObjectsV2
 */
public fun S3Bucket.listObjectsV2Paginated(
  continuationToken: String? = null,
  maxKeys: Int? = null,
  prefix: String? = null,
  delimiter: String? = null,
  encodingType: String? = null,
  expectedBucketOwner: String? = null,
  requestPayer: String? = null
) = org.http4k.connect.paginated(::invoke, ListObjectsV2(continuationToken, maxKeys, prefix,
    delimiter, encodingType, expectedBucketOwner, requestPayer))

/**
 * @see org.http4k.connect.amazon.s3.action.GetObject
 */
public fun S3Bucket.getObject(key: BucketKey) = invoke(GetObject(key))

/**
 * @see org.http4k.connect.amazon.s3.action.DeleteObject
 */
public fun S3Bucket.deleteObject(key: BucketKey) = invoke(DeleteObject(key))

/**
 * @see org.http4k.connect.amazon.s3.action.CopyObject
 */
public fun S3Bucket.copyObject(
  sourceBucket: BucketName,
  source: BucketKey,
  destination: BucketKey
) = invoke(CopyObject(sourceBucket, source, destination))
