/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.s3.model;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.aws.AwsCredentialScope;
import org.http4k.aws.AwsCredentials;
import org.http4k.aws.AwsPreRequestSigner;
import org.http4k.aws.AwsPreSignedRequest;
import org.http4k.aws.AwsRequestPreSignerKt;
import org.http4k.cloudnative.env.Environment;
import org.http4k.connect.amazon.CredentialsProvider;
import org.http4k.connect.amazon.CredentialsProviderKt;
import org.http4k.connect.amazon.core.model.Region;
import org.http4k.connect.amazon.s3.S3;
import org.http4k.connect.amazon.s3.model.BucketKey;
import org.http4k.connect.amazon.s3.model.BucketName;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.core.UriKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0010BA\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u0013J=\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2 \b\u0002\u0010\u001e\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\"0!0 j\u0002`\u001f\u00a2\u0006\u0002\u0010#J=\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2 \b\u0002\u0010\u001e\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\"0!0 j\u0002`\u001f\u00a2\u0006\u0002\u0010#J=\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2 \b\u0002\u0010\u001e\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\"0!0 j\u0002`\u001f\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/http4k/connect/amazon/s3/model/S3BucketPreSigner;", "", "bucketName", "Lorg/http4k/connect/amazon/s3/model/BucketName;", "region", "Lorg/http4k/connect/amazon/core/model/Region;", "credentialsProvider", "Lorg/http4k/connect/amazon/CredentialsProvider;", "clock", "Ljava/time/Clock;", "forcePathStyle", "", "<init>", "(Lorg/http4k/connect/amazon/s3/model/BucketName;Lorg/http4k/connect/amazon/core/model/Region;Lorg/http4k/connect/amazon/CredentialsProvider;Ljava/time/Clock;Z)V", "credentials", "Lorg/http4k/aws/AwsCredentials;", "(Lorg/http4k/connect/amazon/s3/model/BucketName;Lorg/http4k/connect/amazon/core/model/Region;Lorg/http4k/aws/AwsCredentials;Ljava/time/Clock;Z)V", "env", "Lorg/http4k/cloudnative/env/Environment;", "(Lorg/http4k/connect/amazon/s3/model/BucketName;Lorg/http4k/connect/amazon/core/model/Region;Lorg/http4k/cloudnative/env/Environment;Ljava/time/Clock;ZLorg/http4k/connect/amazon/CredentialsProvider;)V", "preSigner", "Lorg/http4k/aws/AwsPreRequestSigner;", "bucketUri", "Lorg/http4k/core/Uri;", "get", "Lorg/http4k/aws/AwsPreSignedRequest;", "key", "Lorg/http4k/connect/amazon/s3/model/BucketKey;", "duration", "Ljava/time/Duration;", "headers", "Lorg/http4k/core/Headers;", "", "Lkotlin/Pair;", "", "(Lorg/http4k/connect/amazon/s3/model/BucketKey;Ljava/time/Duration;Ljava/util/List;)Lorg/http4k/aws/AwsPreSignedRequest;", "put", "delete", "http4k-connect-amazon-s3"})
public final class S3BucketPreSigner {
    @NotNull
    private final AwsPreRequestSigner preSigner;
    @NotNull
    private final Uri bucketUri;

    public S3BucketPreSigner(@NotNull BucketName bucketName, @NotNull Region region, @NotNull CredentialsProvider credentialsProvider, @NotNull Clock clock, boolean forcePathStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)bucketName), (String)"bucketName");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.preSigner = AwsRequestPreSignerKt.AwsRequestPreSigner((AwsCredentialScope)new AwsCredentialScope((String)region.getValue(), (String)S3.Companion.getAwsService().getValue()), (Function0)((Function0)credentialsProvider), (Clock)clock);
        S3BucketPreSigner s3BucketPreSigner = this;
        S3BucketPreSigner s3BucketPreSigner2 = this;
        boolean bl = false;
        boolean usePathStyleApi = forcePathStyle || bucketName.requiresPathStyleApi();
        String pathPrefix = usePathStyleApi ? "" + '/' + (Object)((Object)bucketName) : "";
        String subdomain = usePathStyleApi ? "" : "" + (Object)((Object)bucketName) + '.';
        s3BucketPreSigner2.bucketUri = Uri.Companion.of("https://" + subdomain + S3.Companion.getAwsService() + '.' + region + ".amazonaws.com").path(pathPrefix);
    }

    public /* synthetic */ S3BucketPreSigner(BucketName bucketName, Region region, CredentialsProvider credentialsProvider, Clock clock, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            clock = Clock.systemUTC();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(bucketName, region, credentialsProvider, clock, bl);
    }

    public S3BucketPreSigner(@NotNull BucketName bucketName, @NotNull Region region, @NotNull AwsCredentials credentials, @NotNull Clock clock, boolean forcePathStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)bucketName), (String)"bucketName");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this(bucketName, region, () -> S3BucketPreSigner._init_$lambda$0(credentials), clock, forcePathStyle);
    }

    public /* synthetic */ S3BucketPreSigner(BucketName bucketName, Region region, AwsCredentials awsCredentials, Clock clock, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            clock = Clock.systemUTC();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(bucketName, region, awsCredentials, clock, bl);
    }

    public S3BucketPreSigner(@NotNull BucketName bucketName, @NotNull Region region, @NotNull Environment env, @NotNull Clock clock, boolean forcePathStyle, @NotNull CredentialsProvider credentialsProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)bucketName), (String)"bucketName");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)credentialsProvider, (String)"credentialsProvider");
        this(bucketName, region, credentialsProvider, clock, forcePathStyle);
    }

    public /* synthetic */ S3BucketPreSigner(BucketName bucketName, Region region, Environment environment, Clock clock, boolean bl, CredentialsProvider credentialsProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            environment = Environment.Companion.getENV();
        }
        if ((n & 8) != 0) {
            clock = Clock.systemUTC();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            credentialsProvider = CredentialsProviderKt.Environment((CredentialsProvider.Companion)CredentialsProvider.Companion, (Environment)environment);
        }
        this(bucketName, region, environment, clock, bl, credentialsProvider);
    }

    @NotNull
    public final AwsPreSignedRequest get(@NotNull BucketKey key, @NotNull Duration duration, @NotNull List<Pair<String, String>> headers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return (AwsPreSignedRequest)this.preSigner.invoke((Object)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (Uri)UriKt.appendToPath((Uri)this.bucketUri, (String)((String)key.getValue())), null, (int)4, null).headers(headers), (Object)duration);
    }

    public static /* synthetic */ AwsPreSignedRequest get$default(S3BucketPreSigner s3BucketPreSigner, BucketKey bucketKey, Duration duration, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return s3BucketPreSigner.get(bucketKey, duration, list);
    }

    @NotNull
    public final AwsPreSignedRequest put(@NotNull BucketKey key, @NotNull Duration duration, @NotNull List<Pair<String, String>> headers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return (AwsPreSignedRequest)this.preSigner.invoke((Object)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.PUT, (Uri)UriKt.appendToPath((Uri)this.bucketUri, (String)((String)key.getValue())), null, (int)4, null).headers(headers), (Object)duration);
    }

    public static /* synthetic */ AwsPreSignedRequest put$default(S3BucketPreSigner s3BucketPreSigner, BucketKey bucketKey, Duration duration, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return s3BucketPreSigner.put(bucketKey, duration, list);
    }

    @NotNull
    public final AwsPreSignedRequest delete(@NotNull BucketKey key, @NotNull Duration duration, @NotNull List<Pair<String, String>> headers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return (AwsPreSignedRequest)this.preSigner.invoke((Object)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.DELETE, (Uri)UriKt.appendToPath((Uri)this.bucketUri, (String)((String)key.getValue())), null, (int)4, null).headers(headers), (Object)duration);
    }

    public static /* synthetic */ AwsPreSignedRequest delete$default(S3BucketPreSigner s3BucketPreSigner, BucketKey bucketKey, Duration duration, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return s3BucketPreSigner.delete(bucketKey, duration, list);
    }

    private static final AwsCredentials _init_$lambda$0(AwsCredentials $credentials) {
        Intrinsics.checkNotNullParameter((Object)$credentials, (String)"$credentials");
        return $credentials;
    }
}

