package org.http4k.connect.amazon.s3

import dev.forkhandles.result4k.Result
import kotlin.Unit
import org.http4k.connect.RemoteFailure
import org.http4k.connect.amazon.core.model.Region
import org.http4k.connect.amazon.s3.action.BucketList
import org.http4k.connect.amazon.s3.action.CreateBucket
import org.http4k.connect.amazon.s3.action.ListBuckets
import org.http4k.connect.amazon.s3.model.BucketName

/**
 * @see org.http4k.connect.amazon.s3.action.CreateBucket
 */
public fun S3.createBucket(bucketName: BucketName, region: Region): Result<Unit, RemoteFailure> =
    invoke(CreateBucket(bucketName, region))

/**
 * @see org.http4k.connect.amazon.s3.action.ListBuckets
 */
public fun S3.listBuckets(): Result<BucketList, RemoteFailure> = invoke(ListBuckets())
