/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.s3.model;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.aws.AwsCredentialScope;
import org.http4k.aws.AwsCredentials;
import org.http4k.aws.AwsPreRequestSigner;
import org.http4k.aws.AwsPreSignedRequest;
import org.http4k.aws.AwsRequestPreSignerKt;
import org.http4k.connect.amazon.CredentialsProvider;
import org.http4k.connect.amazon.core.model.Region;
import org.http4k.connect.amazon.s3.S3;
import org.http4k.connect.amazon.s3.model.BucketKey;
import org.http4k.connect.amazon.s3.model.BucketName;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.core.UriKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ<\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192$\b\u0002\u0010\u001a\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cj\u0002`\u001e0\u001bj\u0002`\u001fJ<\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192$\b\u0002\u0010\u001a\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cj\u0002`\u001e0\u001bj\u0002`\u001fJ<\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192$\b\u0002\u0010\u001a\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cj\u0002`\u001e0\u001bj\u0002`\u001fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lorg/http4k/connect/amazon/s3/model/S3BucketPreSigner;", "", "bucketName", "Lorg/http4k/connect/amazon/s3/model/BucketName;", "region", "Lorg/http4k/connect/amazon/core/model/Region;", "credentials", "Lorg/http4k/aws/AwsCredentials;", "clock", "Ljava/time/Clock;", "(Lorg/http4k/connect/amazon/s3/model/BucketName;Lorg/http4k/connect/amazon/core/model/Region;Lorg/http4k/aws/AwsCredentials;Ljava/time/Clock;)V", "credentialsProvider", "Lorg/http4k/connect/amazon/CredentialsProvider;", "(Lorg/http4k/connect/amazon/s3/model/BucketName;Lorg/http4k/connect/amazon/core/model/Region;Lorg/http4k/connect/amazon/CredentialsProvider;Ljava/time/Clock;)V", "bucketUri", "Lorg/http4k/core/Uri;", "preSigner", "Lorg/http4k/aws/AwsPreRequestSigner;", "getPreSigner", "()Lorg/http4k/aws/AwsPreRequestSigner;", "delete", "Lorg/http4k/aws/AwsPreSignedRequest;", "key", "Lorg/http4k/connect/amazon/s3/model/BucketKey;", "duration", "Ljava/time/Duration;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "get", "put", "http4k-connect-amazon-s3"})
public final class S3BucketPreSigner {
    @NotNull
    private final AwsPreRequestSigner preSigner;
    @NotNull
    private final Uri bucketUri;

    public S3BucketPreSigner(@NotNull BucketName bucketName, @NotNull Region region, @NotNull CredentialsProvider credentialsProvider, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)((Object)bucketName), (String)"bucketName");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.preSigner = AwsRequestPreSignerKt.AwsRequestPreSigner((AwsCredentialScope)new AwsCredentialScope((String)region.getValue(), (String)S3.Companion.getAwsService().getValue()), (Function0)((Function0)credentialsProvider), (Clock)clock);
        S3BucketPreSigner s3BucketPreSigner = this;
        S3BucketPreSigner s3BucketPreSigner2 = this;
        boolean bl = false;
        String pathPrefix = bucketName.requiresPathStyleApi() ? "" + '/' + (Object)((Object)bucketName) : "";
        String subdomain = bucketName.requiresPathStyleApi() ? "" : "" + (Object)((Object)bucketName) + '.';
        s3BucketPreSigner2.bucketUri = Uri.Companion.of("https://" + subdomain + S3.Companion.getAwsService() + '.' + region + ".amazonaws.com").path(pathPrefix);
    }

    public /* synthetic */ S3BucketPreSigner(BucketName bucketName, Region region, CredentialsProvider credentialsProvider, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemDefaultZone();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemDefaultZone(...)");
            clock = clock2;
        }
        this(bucketName, region, credentialsProvider, clock);
    }

    public S3BucketPreSigner(@NotNull BucketName bucketName, @NotNull Region region, @NotNull AwsCredentials credentials, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)((Object)bucketName), (String)"bucketName");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this(bucketName, region, () -> S3BucketPreSigner._init_$lambda$0(credentials), clock);
    }

    public /* synthetic */ S3BucketPreSigner(BucketName bucketName, Region region, AwsCredentials awsCredentials, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemDefaultZone();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemDefaultZone(...)");
            clock = clock2;
        }
        this(bucketName, region, awsCredentials, clock);
    }

    @NotNull
    public final AwsPreRequestSigner getPreSigner() {
        return this.preSigner;
    }

    @NotNull
    public final AwsPreSignedRequest get(@NotNull BucketKey key, @NotNull Duration duration, @NotNull List<Pair<String, String>> headers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return (AwsPreSignedRequest)this.preSigner.invoke((Object)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (Uri)UriKt.appendToPath((Uri)this.bucketUri, (String)((String)key.getValue())), null, (int)4, null).headers(headers), (Object)duration);
    }

    public static /* synthetic */ AwsPreSignedRequest get$default(S3BucketPreSigner s3BucketPreSigner, BucketKey bucketKey, Duration duration, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return s3BucketPreSigner.get(bucketKey, duration, list);
    }

    @NotNull
    public final AwsPreSignedRequest put(@NotNull BucketKey key, @NotNull Duration duration, @NotNull List<Pair<String, String>> headers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return (AwsPreSignedRequest)this.preSigner.invoke((Object)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.PUT, (Uri)UriKt.appendToPath((Uri)this.bucketUri, (String)((String)key.getValue())), null, (int)4, null).headers(headers), (Object)duration);
    }

    public static /* synthetic */ AwsPreSignedRequest put$default(S3BucketPreSigner s3BucketPreSigner, BucketKey bucketKey, Duration duration, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return s3BucketPreSigner.put(bucketKey, duration, list);
    }

    @NotNull
    public final AwsPreSignedRequest delete(@NotNull BucketKey key, @NotNull Duration duration, @NotNull List<Pair<String, String>> headers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return (AwsPreSignedRequest)this.preSigner.invoke((Object)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.DELETE, (Uri)UriKt.appendToPath((Uri)this.bucketUri, (String)((String)key.getValue())), null, (int)4, null).headers(headers), (Object)duration);
    }

    public static /* synthetic */ AwsPreSignedRequest delete$default(S3BucketPreSigner s3BucketPreSigner, BucketKey bucketKey, Duration duration, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return s3BucketPreSigner.delete(bucketKey, duration, list);
    }

    private static final AwsCredentials _init_$lambda$0(AwsCredentials $credentials) {
        Intrinsics.checkNotNullParameter((Object)$credentials, (String)"$credentials");
        return $credentials;
    }
}

