package org.http4k.connect.amazon.ses

import dev.forkhandles.result4k.Result
import kotlin.collections.Set
import org.http4k.connect.RemoteFailure
import org.http4k.connect.amazon.ses.action.SendEmail
import org.http4k.connect.amazon.ses.action.SendEmailResponse
import org.http4k.connect.amazon.ses.model.Destination
import org.http4k.connect.amazon.ses.model.EmailAddress
import org.http4k.connect.amazon.ses.model.Message

/**
 * @see org.http4k.connect.amazon.ses.action.SendEmail
 */
public fun SES.sendEmail(
  source: EmailAddress,
  destination: Destination,
  message: Message,
  replyToAddresses: Set<EmailAddress>? = null,
): Result<SendEmailResponse, RemoteFailure> = invoke(SendEmail(source, destination, message,
    replyToAddresses))
