package org.http4k.connect.amazon.ses

import dev.forkhandles.result4k.Result
import kotlin.String
import kotlin.collections.List
import org.http4k.connect.RemoteFailure
import org.http4k.connect.amazon.ses.action.SendEmail
import org.http4k.connect.amazon.ses.action.SendEmailResponse
import org.http4k.connect.amazon.ses.model.Destination
import org.http4k.connect.amazon.ses.model.EmailAddress
import org.http4k.connect.amazon.ses.model.EmailContent
import org.http4k.connect.amazon.ses.model.MessageTag

/**
 * @see org.http4k.connect.amazon.ses.action.SendEmail
 */
public fun SES.sendEmail(
  content: EmailContent,
  destination: Destination? = null,
  fromEmailAddress: EmailAddress? = null,
  configurationSetName: String? = null,
  emailTags: List<MessageTag>? = null,
  replyToAddresses: List<EmailAddress>? = null,
): Result<SendEmailResponse, RemoteFailure> = invoke(SendEmail(content, destination, fromEmailAddress, configurationSetName, emailTags, replyToAddresses))
