package org.http4k.connect.amazon.sns

import kotlin.String
import kotlin.collections.List
import kotlin.collections.Map
import org.http4k.connect.amazon.core.model.ARN
import org.http4k.connect.amazon.core.model.Tag
import org.http4k.connect.amazon.sns.action.CreateTopic
import org.http4k.connect.amazon.sns.action.DeleteTopic
import org.http4k.connect.amazon.sns.action.ListTopics
import org.http4k.connect.amazon.sns.action.PublishMessage
import org.http4k.connect.amazon.sns.model.MessageAttribute
import org.http4k.connect.amazon.sns.model.PhoneNumber
import org.http4k.connect.amazon.sns.model.TopicName

/**
 * @see org.http4k.connect.amazon.sns.action.PublishMessage
 */
public fun SNS.publishMessage(
  message: String,
  subject: String? = null,
  phoneNumber: PhoneNumber? = null,
  topicArn: ARN? = null,
  targetArn: ARN? = null,
  messageDeduplicationId: String? = null,
  messageGroupId: String? = null,
  messageStructure: String? = null,
  attributes: List<MessageAttribute>? = null
) = invoke(PublishMessage(message, subject, phoneNumber, topicArn, targetArn,
    messageDeduplicationId, messageGroupId, messageStructure, attributes))

/**
 * @see org.http4k.connect.amazon.sns.action.ListTopics
 */
public fun SNS.listTopics(NextToken: String? = null) = invoke(ListTopics(NextToken))

/**
 * @see org.http4k.connect.amazon.sns.action.ListTopics
 */
public fun SNS.listTopicsPaginated(NextToken: String? = null) =
    org.http4k.connect.paginated(::invoke, ListTopics(NextToken))

/**
 * @see org.http4k.connect.amazon.sns.action.DeleteTopic
 */
public fun SNS.deleteTopic(topicArn: ARN) = invoke(DeleteTopic(topicArn))

/**
 * @see org.http4k.connect.amazon.sns.action.CreateTopic
 */
public fun SNS.createTopic(
  topicName: TopicName,
  tags: List<Tag>,
  attributes: Map<String, String>
) = invoke(CreateTopic(topicName, tags, attributes))
