package org.http4k.connect.amazon.sns

import dev.forkhandles.result4k.Result
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.sequences.Sequence
import org.http4k.connect.RemoteFailure
import org.http4k.connect.amazon.core.model.ARN
import org.http4k.connect.amazon.core.model.Tag
import org.http4k.connect.amazon.sns.action.CreateTopic
import org.http4k.connect.amazon.sns.action.CreatedTopic
import org.http4k.connect.amazon.sns.action.DeleteTopic
import org.http4k.connect.amazon.sns.action.ListTopics
import org.http4k.connect.amazon.sns.action.PublishBatch
import org.http4k.connect.amazon.sns.action.PublishBatchRequestEntry
import org.http4k.connect.amazon.sns.action.PublishBatchResult
import org.http4k.connect.amazon.sns.action.PublishMessage
import org.http4k.connect.amazon.sns.action.PublishedMessage
import org.http4k.connect.amazon.sns.action.TopicList
import org.http4k.connect.amazon.sns.model.MessageAttribute
import org.http4k.connect.amazon.sns.model.PhoneNumber
import org.http4k.connect.amazon.sns.model.TopicName

/**
 * @see org.http4k.connect.amazon.sns.action.CreateTopic
 */
public fun SNS.createTopic(
  topicName: TopicName,
  tags: List<Tag> = emptyList(),
  attributes: Map<String, String> = emptyMap(),
): Result<CreatedTopic, RemoteFailure> = invoke(CreateTopic(topicName, tags, attributes))

/**
 * @see org.http4k.connect.amazon.sns.action.DeleteTopic
 */
public fun SNS.deleteTopic(topicArn: ARN): Result<Unit, RemoteFailure> =
    invoke(DeleteTopic(topicArn))

/**
 * @see org.http4k.connect.amazon.sns.action.ListTopics
 */
public fun SNS.listTopics(NextToken: String? = null): Result<TopicList, RemoteFailure> =
    invoke(ListTopics(NextToken))

/**
 * @see org.http4k.connect.amazon.sns.action.ListTopics
 */
public fun SNS.listTopicsPaginated(NextToken: String? = null):
    Sequence<Result<List<ARN>, RemoteFailure>> = org.http4k.connect.paginated(::invoke,
    ListTopics(NextToken))

/**
 * @see org.http4k.connect.amazon.sns.action.PublishBatch
 */
public fun SNS.publishBatch(TopicArn: ARN,
    PublishBatchRequestEntries: List<PublishBatchRequestEntry>):
    Result<PublishBatchResult, RemoteFailure> = invoke(PublishBatch(TopicArn,
    PublishBatchRequestEntries))

/**
 * @see org.http4k.connect.amazon.sns.action.PublishMessage
 */
public fun SNS.publishMessage(
  message: String,
  subject: String? = null,
  phoneNumber: PhoneNumber? = null,
  topicArn: ARN? = null,
  targetArn: ARN? = null,
  messageDeduplicationId: String? = null,
  messageGroupId: String? = null,
  messageStructure: String? = null,
  attributes: List<MessageAttribute>? = null,
): Result<PublishedMessage, RemoteFailure> = invoke(PublishMessage(message, subject, phoneNumber,
    topicArn, targetArn, messageDeduplicationId, messageGroupId, messageStructure, attributes))
