package org.http4k.connect

import dev.forkhandles.result4k.Result
import org.http4k.core.Method
import org.http4k.core.Request
import org.http4k.core.Response
import org.http4k.core.Status
import org.http4k.core.Uri

interface Action<R> {
    fun toRequest(): Request
    fun toResult(response: Response): Result<R, RemoteFailure>
}

data class RemoteFailure(val method: Method, val uri: Uri, val status: Status, val message: String? = null) {
    fun throwIt(): Nothing = throw Exception(toString())
}
