/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.util;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.http4k.core.Uri;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B+\u0012\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/http4k/connect/util/WebBrowser;", "Lorg/http4k/connect/util/Browser;", "open", "Lkotlin/Function1;", "", "Ljava/lang/Process;", "Lorg/http4k/connect/util/OpenBrowser;", "operatingSystemName", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "navigateTo", "Ldev/forkhandles/result4k/Result;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "url", "Lorg/http4k/core/Uri;", "linuxBrowser", "Browser", "http4k-connect-core"})
@SourceDebugExtension(value={"SMAP\nWebBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebBrowser.kt\norg/http4k/connect/util/WebBrowser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,42:1\n1#2:43\n37#3,2:44\n*S KotlinDebug\n*F\n+ 1 WebBrowser.kt\norg/http4k/connect/util/WebBrowser\n*L\n8#1:44,2\n*E\n"})
public final class WebBrowser
implements org.http4k.connect.util.Browser {
    @NotNull
    private final Function1<String, Process> open;
    @NotNull
    private final String operatingSystemName;

    public WebBrowser(@NotNull Function1<? super String, ? extends Process> open, @NotNull String operatingSystemName) {
        Intrinsics.checkNotNullParameter(open, (String)"open");
        Intrinsics.checkNotNullParameter((Object)operatingSystemName, (String)"operatingSystemName");
        this.open = open;
        this.operatingSystemName = operatingSystemName;
    }

    public /* synthetic */ WebBrowser(Function1 function1, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = WebBrowser::_init_$lambda$0;
        }
        if ((n & 2) != 0) {
            string = System.getProperty("os.name");
        }
        this((Function1<? super String, ? extends Process>)function1, string);
    }

    @Override
    @NotNull
    public Result<Unit, Exception> navigateTo(@NotNull Uri url) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            Object object;
            if (StringsKt.startsWith$default((String)this.operatingSystemName, (String)"Mac OS", (boolean)false, (int)2, null)) {
                object = this.open.invoke((Object)("open " + url));
            } else if (StringsKt.startsWith$default((String)this.operatingSystemName, (String)"Windows", (boolean)false, (int)2, null)) {
                object = this.open.invoke((Object)("rundll32 url.dll,FileProtocolHandler " + url));
            } else {
                this.linuxBrowser(url);
                object = Unit.INSTANCE;
            }
            result = (Result)new Success((Object)Unit.INSTANCE);
        }
        catch (Exception e) {
            result = (Result)new Failure((Object)new Exception("Could not open system browser"));
        }
        return result;
    }

    private final void linuxBrowser(Uri url) {
        String browser = null;
        for (Browser b : Browser.getEntries()) {
            String string;
            if (browser != null || ((Process)this.open.invoke((Object)("which " + b.name()))).getInputStream().read() == -1) continue;
            String string2 = string = b.name();
            StringBuilder stringBuilder = new StringBuilder();
            Function1<String, Process> function1 = this.open;
            boolean bl = false;
            browser = b.name();
            Unit unit = Unit.INSTANCE;
            function1.invoke((Object)stringBuilder.append(string).append(' ').append(url).toString());
        }
        if (browser == null) {
            throw new Exception("No web browser found");
        }
    }

    private static final Process _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{" "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]));
    }

    public WebBrowser() {
        this(null, null, 3, null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000e\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/http4k/connect/util/WebBrowser$Browser;", "", "<init>", "(Ljava/lang/String;I)V", "google-chrome", "firefox", "mozilla", "epiphany", "konqueror", "netscape", "opera", "links", "lynx", "chromium", "brave-browser", "http4k-connect-core"})
    private static final class Browser
    extends Enum<Browser> {
        public static final /* enum */ Browser google-chrome = new Browser();
        public static final /* enum */ Browser firefox = new Browser();
        public static final /* enum */ Browser mozilla = new Browser();
        public static final /* enum */ Browser epiphany = new Browser();
        public static final /* enum */ Browser konqueror = new Browser();
        public static final /* enum */ Browser netscape = new Browser();
        public static final /* enum */ Browser opera = new Browser();
        public static final /* enum */ Browser links = new Browser();
        public static final /* enum */ Browser lynx = new Browser();
        public static final /* enum */ Browser chromium = new Browser();
        public static final /* enum */ Browser brave-browser = new Browser();
        private static final /* synthetic */ Browser[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Browser[] values() {
            return (Browser[])$VALUES.clone();
        }

        public static Browser valueOf(String value) {
            return Enum.valueOf(Browser.class, value);
        }

        @NotNull
        public static EnumEntries<Browser> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = browserArray = new Browser[]{Browser.google-chrome, Browser.firefox, Browser.mozilla, Browser.epiphany, Browser.konqueror, Browser.netscape, Browser.opera, Browser.links, Browser.lynx, Browser.chromium, Browser.brave-browser};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

