/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.util;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.http4k.core.Uri;
import org.http4k.util.OperatingSystem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B+\u0012\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/http4k/connect/util/WebBrowser;", "Lorg/http4k/connect/util/Browser;", "open", "Lkotlin/Function1;", "", "Ljava/lang/Process;", "Lorg/http4k/connect/util/OpenBrowser;", "operatingSystem", "Lorg/http4k/util/OperatingSystem;", "<init>", "(Lkotlin/jvm/functions/Function1;Lorg/http4k/util/OperatingSystem;)V", "navigateTo", "Ldev/forkhandles/result4k/Result;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "url", "Lorg/http4k/core/Uri;", "linuxBrowser", "Browser", "http4k-connect-core"})
@SourceDebugExtension(value={"SMAP\nWebBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebBrowser.kt\norg/http4k/connect/util/WebBrowser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,46:1\n1#2:47\n37#3,2:48\n*S KotlinDebug\n*F\n+ 1 WebBrowser.kt\norg/http4k/connect/util/WebBrowser\n*L\n12#1:48,2\n*E\n"})
public final class WebBrowser
implements org.http4k.connect.util.Browser {
    @NotNull
    private final Function1<String, Process> open;
    @NotNull
    private final OperatingSystem operatingSystem;

    public WebBrowser(@NotNull Function1<? super String, ? extends Process> open, @NotNull OperatingSystem operatingSystem) {
        Intrinsics.checkNotNullParameter(open, (String)"open");
        Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
        this.open = open;
        this.operatingSystem = operatingSystem;
    }

    public /* synthetic */ WebBrowser(Function1 function1, OperatingSystem operatingSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = WebBrowser::_init_$lambda$0;
        }
        if ((n & 2) != 0) {
            operatingSystem = OperatingSystem.Companion.detect();
        }
        this((Function1<? super String, ? extends Process>)function1, operatingSystem);
    }

    @Override
    @NotNull
    public Result<Unit, Exception> navigateTo(@NotNull Uri url) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            switch (WhenMappings.$EnumSwitchMapping$0[this.operatingSystem.ordinal()]) {
                case 1: {
                    Object object = this.open.invoke((Object)("open " + url));
                    break;
                }
                case 2: {
                    Object object = this.open.invoke((Object)("rundll32 url.dll,FileProtocolHandler " + url));
                    break;
                }
                case 3: {
                    this.linuxBrowser(url);
                    Object object = Unit.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            result = (Result)new Success((Object)Unit.INSTANCE);
        }
        catch (Exception e) {
            result = (Result)new Failure((Object)new Exception("Could not open system browser"));
        }
        return result;
    }

    private final void linuxBrowser(Uri url) {
        String browser = null;
        for (Browser b : Browser.getEntries()) {
            String string;
            if (browser != null || ((Process)this.open.invoke((Object)("which " + b.name()))).getInputStream().read() == -1) continue;
            String string2 = string = b.name();
            Function1<String, Process> function1 = this.open;
            boolean bl = false;
            browser = b.name();
            function1.invoke((Object)(string + " " + url));
        }
        if (browser == null) {
            throw new Exception("No web browser found");
        }
    }

    private static final Process _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{" "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]));
    }

    public WebBrowser() {
        this(null, null, 3, null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000e\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/http4k/connect/util/WebBrowser$Browser;", "", "<init>", "(Ljava/lang/String;I)V", "google-chrome", "firefox", "mozilla", "epiphany", "konqueror", "netscape", "opera", "links", "lynx", "chromium", "brave-browser", "http4k-connect-core"})
    private static final class Browser
    extends Enum<Browser> {
        public static final /* enum */ Browser google-chrome = new Browser();
        public static final /* enum */ Browser firefox = new Browser();
        public static final /* enum */ Browser mozilla = new Browser();
        public static final /* enum */ Browser epiphany = new Browser();
        public static final /* enum */ Browser konqueror = new Browser();
        public static final /* enum */ Browser netscape = new Browser();
        public static final /* enum */ Browser opera = new Browser();
        public static final /* enum */ Browser links = new Browser();
        public static final /* enum */ Browser lynx = new Browser();
        public static final /* enum */ Browser chromium = new Browser();
        public static final /* enum */ Browser brave-browser = new Browser();
        private static final /* synthetic */ Browser[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Browser[] values() {
            return (Browser[])$VALUES.clone();
        }

        public static Browser valueOf(String value) {
            return Enum.valueOf(Browser.class, value);
        }

        @NotNull
        public static EnumEntries<Browser> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = browserArray = new Browser[]{Browser.google-chrome, Browser.firefox, Browser.mozilla, Browser.epiphany, Browser.konqueror, Browser.netscape, Browser.opera, Browser.links, Browser.lynx, Browser.chromium, Browser.brave-browser};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OperatingSystem.values().length];
            try {
                nArray[OperatingSystem.MacOS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

