package org.http4k.connect.example

import kotlin.Int
import kotlin.String
import org.http4k.connect.example.action.Echo
import org.http4k.connect.example.action.Reverse
import org.http4k.connect.example.action.Split

/**
 * @see org.http4k.connect.example.action.Echo
 */
public fun Example.echo(`value`: String) = invoke(Echo(value))

/**
 * @see org.http4k.connect.example.action.Split
 */
public fun Example.split(`value`: String, token: Int? = null) = invoke(Split(value, token))

/**
 * @see org.http4k.connect.example.action.Split
 */
public fun Example.splitPaginated(`value`: String, token: Int? = null) =
    org.http4k.connect.paginated(::invoke, Split(value, token))

/**
 * @see org.http4k.connect.example.action.Reverse
 */
public fun Example.reverse(`value`: String) = invoke(Reverse(value))
