package org.http4k.connect.example

import dev.forkhandles.result4k.Result
import kotlin.Char
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlin.sequences.Sequence
import org.http4k.connect.RemoteFailure
import org.http4k.connect.example.action.Echo
import org.http4k.connect.example.action.Echoed
import org.http4k.connect.example.action.Reverse
import org.http4k.connect.example.action.Reversed
import org.http4k.connect.example.action.Split
import org.http4k.connect.example.action.SplitChunk

/**
 * @see org.http4k.connect.example.action.Echo
 */
public fun Example.echo(`value`: String): Result<Echoed, RemoteFailure> = invoke(Echo(value))

/**
 * @see org.http4k.connect.example.action.Reverse
 */
public fun Example.reverse(`value`: String): Result<Reversed, RemoteFailure> =
    invoke(Reverse(value))

/**
 * @see org.http4k.connect.example.action.Split
 */
public fun Example.split(`value`: String, token: Int? = null): Result<SplitChunk, RemoteFailure> =
    invoke(Split(value, token))

/**
 * @see org.http4k.connect.example.action.Split
 */
public fun Example.splitPaginated(`value`: String, token: Int? = null):
    Sequence<Result<List<Char>, RemoteFailure>> = org.http4k.connect.paginated(::invoke,
    Split(value, token))
