package org.http4k.connect.github.api

import dev.forkhandles.result4k.Result
import org.http4k.connect.RemoteFailure
import org.http4k.connect.github.api.action.GetAuthedUser
import org.http4k.connect.github.api.action.GetUser
import org.http4k.connect.github.api.action.GitHubUser
import org.http4k.connect.github.model.Owner

/**
 * @see org.http4k.connect.github.api.action.GetAuthedUser
 */
public fun GitHub.getAuthedUser(): Result<GitHubUser, RemoteFailure> = invoke(GetAuthedUser)

/**
 * @see org.http4k.connect.github.api.action.GetUser
 */
public fun GitHub.getUser(user: Owner): Result<GitHubUser, RemoteFailure> = invoke(GetUser(user))
