/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.kafka.rest.model;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.connect.kafka.rest.model.ConsumerInstance;
import org.http4k.connect.kafka.rest.model.Offset;
import org.http4k.connect.kafka.rest.model.Topic;
import org.http4k.connect.kafka.rest.model.TopicOffsetState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\tJ\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001cJ\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\u0015\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u00c6\u0003J9\u0010\"\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u00c6\u0001J\u0013\u0010#\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0014H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lorg/http4k/connect/kafka/rest/model/ConsumerState;", "", "instances", "", "Lorg/http4k/connect/kafka/rest/model/ConsumerInstance;", "autoCommit", "", "offsets", "", "Lorg/http4k/connect/kafka/rest/model/Topic;", "Lorg/http4k/connect/kafka/rest/model/TopicOffsetState;", "<init>", "(Ljava/util/Set;ZLjava/util/Map;)V", "getInstances", "()Ljava/util/Set;", "getAutoCommit", "()Z", "getOffsets", "()Ljava/util/Map;", "committedRecords", "", "topic", "add", "instance", "remove", "new", "next", "nextOffset", "Lorg/http4k/connect/kafka/rest/model/Offset;", "commitAt", "lastOffset", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "http4k-connect-kafka-rest-fake"})
public final class ConsumerState {
    @NotNull
    private final Set<ConsumerInstance> instances;
    private final boolean autoCommit;
    @NotNull
    private final Map<Topic, TopicOffsetState> offsets;

    public ConsumerState(@NotNull Set<ConsumerInstance> instances, boolean autoCommit, @NotNull Map<Topic, TopicOffsetState> offsets) {
        Intrinsics.checkNotNullParameter(instances, (String)"instances");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        this.instances = instances;
        this.autoCommit = autoCommit;
        this.offsets = offsets;
    }

    @NotNull
    public final Set<ConsumerInstance> getInstances() {
        return this.instances;
    }

    public final boolean getAutoCommit() {
        return this.autoCommit;
    }

    @NotNull
    public final Map<Topic, TopicOffsetState> getOffsets() {
        return this.offsets;
    }

    public final int committedRecords(@NotNull Topic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        TopicOffsetState topicOffsetState = this.offsets.get(topic);
        return topicOffsetState != null && (topicOffsetState = topicOffsetState.getCommitted()) != null ? topicOffsetState.getValue() : 0;
    }

    @NotNull
    public final ConsumerState add(@NotNull ConsumerInstance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return ConsumerState.copy$default(this, SetsKt.plus(this.instances, (Object)instance), false, null, 6, null);
    }

    @NotNull
    public final ConsumerState remove(@NotNull ConsumerInstance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return ConsumerState.copy$default(this, SetsKt.minus(this.instances, (Object)instance), false, null, 6, null);
    }

    @NotNull
    public final ConsumerState new(@NotNull Topic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return ConsumerState.copy$default(this, null, false, MapsKt.plus(this.offsets, (Pair)TuplesKt.to((Object)topic, (Object)this.offsets.getOrDefault(topic, new TopicOffsetState(null, null, 3, null)))), 3, null);
    }

    @NotNull
    public final ConsumerState next(@NotNull Topic topic, @NotNull Offset nextOffset) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)nextOffset, (String)"nextOffset");
        return ConsumerState.copy$default(this, null, false, MapsKt.plus(this.offsets, (Pair)TuplesKt.to((Object)topic, (Object)this.offsets.getOrDefault(topic, new TopicOffsetState(null, null, 3, null)).next(nextOffset))), 3, null);
    }

    @NotNull
    public final ConsumerState commitAt(@NotNull Topic topic, @NotNull Offset lastOffset) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)lastOffset, (String)"lastOffset");
        return ConsumerState.copy$default(this, null, false, MapsKt.plus(this.offsets, (Pair)TuplesKt.to((Object)topic, (Object)this.offsets.getOrDefault(topic, new TopicOffsetState(null, null, 3, null)).commitAt(lastOffset))), 3, null);
    }

    @NotNull
    public final Set<ConsumerInstance> component1() {
        return this.instances;
    }

    public final boolean component2() {
        return this.autoCommit;
    }

    @NotNull
    public final Map<Topic, TopicOffsetState> component3() {
        return this.offsets;
    }

    @NotNull
    public final ConsumerState copy(@NotNull Set<ConsumerInstance> instances, boolean autoCommit, @NotNull Map<Topic, TopicOffsetState> offsets) {
        Intrinsics.checkNotNullParameter(instances, (String)"instances");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        return new ConsumerState(instances, autoCommit, offsets);
    }

    public static /* synthetic */ ConsumerState copy$default(ConsumerState consumerState, Set set, boolean bl, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            set = consumerState.instances;
        }
        if ((n & 2) != 0) {
            bl = consumerState.autoCommit;
        }
        if ((n & 4) != 0) {
            map = consumerState.offsets;
        }
        return consumerState.copy(set, bl, map);
    }

    @NotNull
    public String toString() {
        return "ConsumerState(instances=" + this.instances + ", autoCommit=" + this.autoCommit + ", offsets=" + this.offsets + ")";
    }

    public int hashCode() {
        int result = ((Object)this.instances).hashCode();
        result = result * 31 + Boolean.hashCode(this.autoCommit);
        result = result * 31 + ((Object)this.offsets).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConsumerState)) {
            return false;
        }
        ConsumerState consumerState = (ConsumerState)other;
        if (!Intrinsics.areEqual(this.instances, consumerState.instances)) {
            return false;
        }
        if (this.autoCommit != consumerState.autoCommit) {
            return false;
        }
        return Intrinsics.areEqual(this.offsets, consumerState.offsets);
    }
}

