/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.kafka.rest.v2.action;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.connect.kafka.rest.model.BrokerId;
import org.http4k.connect.kafka.rest.v2.action.Replica;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import se.ansman.kotshi.InternalKotshiApi;
import se.ansman.kotshi.KotshiUtils;
import se.ansman.kotshi.NamedJsonAdapter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/http4k/connect/kafka/rest/v2/action/KotshiReplicaJsonAdapter;", "Lse/ansman/kotshi/NamedJsonAdapter;", "Lorg/http4k/connect/kafka/rest/v2/action/Replica;", "moshi", "Lcom/squareup/moshi/Moshi;", "(Lcom/squareup/moshi/Moshi;)V", "brokerAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lorg/http4k/connect/kafka/rest/model/BrokerId;", "options", "Lcom/squareup/moshi/JsonReader$Options;", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "http4k-connect-kafka-rest"})
@InternalKotshiApi
public final class KotshiReplicaJsonAdapter
extends NamedJsonAdapter<Replica> {
    @NotNull
    private final JsonAdapter<BrokerId> brokerAdapter;
    @NotNull
    private final JsonReader.Options options;

    public KotshiReplicaJsonAdapter(@NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        super("KotshiJsonAdapter(Replica)");
        JsonAdapter jsonAdapter = moshi.adapter((Type)((Object)BrokerId.class), SetsKt.emptySet(), "broker");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter(\n      Bro\u2026tOf(),\n      \"broker\"\n  )");
        this.brokerAdapter = jsonAdapter;
        String[] stringArray = new String[]{"broker", "leader", "in_sync"};
        JsonReader.Options options = JsonReader.Options.of((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"of(\n      \"broker\",\n    \u2026der\",\n      \"in_sync\"\n  )");
        this.options = options;
    }

    public void toJson(@NotNull JsonWriter writer, @Nullable Replica value) throws IOException {
        JsonWriter jsonWriter;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (value == null) {
            writer.nullValue();
            return;
        }
        JsonWriter $this$toJson_u24lambda_u240 = jsonWriter = writer.beginObject().name("broker");
        boolean bl = false;
        this.brokerAdapter.toJson($this$toJson_u24lambda_u240, (Object)value.getBroker());
        jsonWriter.name("leader").value(value.getLeader()).name("in_sync").value(value.getIn_sync()).endObject();
    }

    @Nullable
    public Replica fromJson(@NotNull JsonReader reader) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Replica)reader.nextNull();
        }
        BrokerId broker = null;
        boolean leader = false;
        boolean leaderIsSet = false;
        boolean in_sync = false;
        boolean in_syncIsSet = false;
        reader.beginObject();
        while (reader.hasNext()) {
            switch (reader.selectName(this.options)) {
                case 0: {
                    broker = (BrokerId)((Object)this.brokerAdapter.fromJson(reader));
                    break;
                }
                case 1: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.skipValue();
                        break;
                    }
                    leader = reader.nextBoolean();
                    leaderIsSet = true;
                    break;
                }
                case 2: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.skipValue();
                        break;
                    }
                    in_sync = reader.nextBoolean();
                    in_syncIsSet = true;
                    break;
                }
                case -1: {
                    reader.skipName();
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
        StringBuilder errorBuilder = null;
        if (broker == null) {
            errorBuilder = KotshiUtils.appendNullableError$default(errorBuilder, (String)"broker", null, (int)2, null);
        }
        if (!leaderIsSet) {
            errorBuilder = KotshiUtils.appendNullableError$default((StringBuilder)errorBuilder, (String)"leader", null, (int)2, null);
        }
        if (!in_syncIsSet) {
            errorBuilder = KotshiUtils.appendNullableError$default((StringBuilder)errorBuilder, (String)"in_sync", null, (int)2, null);
        }
        if (errorBuilder != null) {
            errorBuilder.append(" (at path ").append(reader.getPath()).append(')');
            throw new JsonDataException(errorBuilder.toString());
        }
        BrokerId brokerId = broker;
        Intrinsics.checkNotNull((Object)((Object)brokerId));
        return new Replica(brokerId, leader, in_sync);
    }
}

