package org.http4k.connect.kafka.rest.v2

import dev.forkhandles.result4k.Result
import java.time.Duration
import kotlin.Array
import kotlin.Unit
import kotlin.collections.List
import org.http4k.connect.RemoteFailure
import org.http4k.connect.kafka.rest.KafkaRest
import org.http4k.connect.kafka.rest.model.ConsumerGroup
import org.http4k.connect.kafka.rest.model.ConsumerInstance
import org.http4k.connect.kafka.rest.model.Topic
import org.http4k.connect.kafka.rest.v2.action.CommitOffsets
import org.http4k.connect.kafka.rest.v2.action.ConsumeRecords
import org.http4k.connect.kafka.rest.v2.action.CreateConsumer
import org.http4k.connect.kafka.rest.v2.action.DeleteConsumer
import org.http4k.connect.kafka.rest.v2.action.GetOffsets
import org.http4k.connect.kafka.rest.v2.action.GetPartitions
import org.http4k.connect.kafka.rest.v2.action.NewConsumer
import org.http4k.connect.kafka.rest.v2.action.Partition
import org.http4k.connect.kafka.rest.v2.action.ProduceMessages
import org.http4k.connect.kafka.rest.v2.action.ProducedMessages
import org.http4k.connect.kafka.rest.v2.action.SeekOffsets
import org.http4k.connect.kafka.rest.v2.action.SubscribeToTopics
import org.http4k.connect.kafka.rest.v2.model.CommitOffset
import org.http4k.connect.kafka.rest.v2.model.CommitOffsetsSet
import org.http4k.connect.kafka.rest.v2.model.Consumer
import org.http4k.connect.kafka.rest.v2.model.PartitionOffsetRequest
import org.http4k.connect.kafka.rest.v2.model.RecordFormat
import org.http4k.connect.kafka.rest.v2.model.Records
import org.http4k.connect.kafka.rest.v2.model.SeekOffset
import org.http4k.connect.kafka.rest.v2.model.TopicRecord

/**
 * @see org.http4k.connect.kafka.rest.v2.action.CommitOffsets
 */
public fun KafkaRest.commitOffsets(
  group: ConsumerGroup,
  instance: ConsumerInstance,
  offsets: List<CommitOffset>,
): Result<Unit?, RemoteFailure> = invoke(CommitOffsets(group, instance, offsets))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.ConsumeRecords
 */
public fun KafkaRest.consumeRecords(
  group: ConsumerGroup,
  instance: ConsumerInstance,
  format: RecordFormat,
  timeout: Duration? = null,
): Result<Array<TopicRecord>?, RemoteFailure> = invoke(ConsumeRecords(group, instance, format,
    timeout))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.CreateConsumer
 */
public fun KafkaRest.createConsumer(group: ConsumerGroup, consumer: Consumer):
    Result<NewConsumer, RemoteFailure> = invoke(CreateConsumer(group, consumer))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.DeleteConsumer
 */
public fun KafkaRest.deleteConsumer(group: ConsumerGroup, instance: ConsumerInstance):
    Result<Unit?, RemoteFailure> = invoke(DeleteConsumer(group, instance))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.GetOffsets
 */
public fun KafkaRest.getOffsets(
  group: ConsumerGroup,
  instance: ConsumerInstance,
  partitions: List<PartitionOffsetRequest>,
): Result<CommitOffsetsSet?, RemoteFailure> = invoke(GetOffsets(group, instance, partitions))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.GetPartitions
 */
public fun KafkaRest.getPartitions(topic: Topic): Result<Array<Partition>?, RemoteFailure> =
    invoke(GetPartitions(topic))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.ProduceMessages
 */
public fun KafkaRest.produceMessages(topic: Topic, records: Records):
    Result<ProducedMessages?, RemoteFailure> = invoke(ProduceMessages(topic, records))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.SeekOffsets
 */
public fun KafkaRest.seekOffsets(
  group: ConsumerGroup,
  instance: ConsumerInstance,
  offsets: List<SeekOffset>,
): Result<Unit?, RemoteFailure> = invoke(SeekOffsets(group, instance, offsets))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.SubscribeToTopics
 */
public fun KafkaRest.subscribeToTopics(
  group: ConsumerGroup,
  instance: ConsumerInstance,
  topics: List<Topic>,
): Result<Unit?, RemoteFailure> = invoke(SubscribeToTopics(group, instance, topics))
