package org.http4k.connect.kafka.rest.v3

import dev.forkhandles.result4k.Result
import kotlin.Array
import kotlin.collections.List
import org.http4k.connect.RemoteFailure
import org.http4k.connect.kafka.rest.KafkaRest
import org.http4k.connect.kafka.rest.model.Topic
import org.http4k.connect.kafka.rest.v3.action.GetPartitions
import org.http4k.connect.kafka.rest.v3.action.GetTopic
import org.http4k.connect.kafka.rest.v3.action.GetTopics
import org.http4k.connect.kafka.rest.v3.action.KafkaPartitionList
import org.http4k.connect.kafka.rest.v3.action.KafkaTopic
import org.http4k.connect.kafka.rest.v3.action.KafkaTopicList
import org.http4k.connect.kafka.rest.v3.action.ProduceRecords
import org.http4k.connect.kafka.rest.v3.action.ProducedRecord
import org.http4k.connect.kafka.rest.v3.model.ClusterId
import org.http4k.connect.kafka.rest.v3.model.Record

/**
 * @see org.http4k.connect.kafka.rest.v3.action.GetPartitions
 */
public fun KafkaRest.getPartitions(id: ClusterId, topic: Topic):
    Result<KafkaPartitionList?, RemoteFailure> = invoke(GetPartitions(id, topic))

/**
 * @see org.http4k.connect.kafka.rest.v3.action.GetTopic
 */
public fun KafkaRest.getTopic(id: ClusterId, topic: Topic): Result<KafkaTopic?, RemoteFailure> =
    invoke(GetTopic(id, topic))

/**
 * @see org.http4k.connect.kafka.rest.v3.action.GetTopics
 */
public fun KafkaRest.getTopics(id: ClusterId): Result<KafkaTopicList?, RemoteFailure> =
    invoke(GetTopics(id))

/**
 * @see org.http4k.connect.kafka.rest.v3.action.ProduceRecords
 */
public fun KafkaRest.produceRecords(
  id: ClusterId,
  topic: Topic,
  records: List<Record>,
): Result<Array<ProducedRecord>?, RemoteFailure> = invoke(ProduceRecords(id, topic, records))
