// Code generated by Kotshi. Do not edit.
package org.http4k.connect.kafka.rest.v2.action

import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.JsonDataException
import com.squareup.moshi.JsonReader
import com.squareup.moshi.JsonWriter
import com.squareup.moshi.Moshi
import com.squareup.moshi.Types.newParameterizedType
import java.io.IOException
import java.lang.StringBuilder
import kotlin.Suppress
import kotlin.apply
import kotlin.collections.List
import kotlin.collections.setOf
import kotlin.jvm.Throws
import org.http4k.connect.kafka.rest.model.BrokerId
import org.http4k.connect.kafka.rest.model.PartitionId
import se.ansman.kotshi.InternalKotshiApi
import se.ansman.kotshi.KotshiUtils.appendNullableError
import se.ansman.kotshi.NamedJsonAdapter

@InternalKotshiApi
@Suppress(
  "DEPRECATION",
  "unused",
  "ClassName",
  "REDUNDANT_PROJECTION",
  "RedundantExplicitType",
  "LocalVariableName",
  "RedundantVisibilityModifier",
  "PLATFORM_CLASS_MAPPED_TO_KOTLIN",
  "IMPLICIT_NOTHING_TYPE_ARGUMENT_IN_RETURN_POSITION",
  "EXPERIMENTAL_API_USAGE",
  "OPT_IN_USAGE",
)
internal class KotshiPartitionJsonAdapter(
  moshi: Moshi,
) : NamedJsonAdapter<Partition>("KotshiJsonAdapter(Partition)") {
  private val partitionAdapter: JsonAdapter<PartitionId> = moshi.adapter(
      PartitionId::class.javaObjectType,
      setOf(),
      "partition"
  )

  private val leaderAdapter: JsonAdapter<BrokerId> = moshi.adapter(
      BrokerId::class.javaObjectType,
      setOf(),
      "leader"
  )

  private val replicasAdapter: JsonAdapter<List<Replica>> = moshi.adapter(
      newParameterizedType(List::class.javaObjectType, Replica::class.javaObjectType),
      setOf(),
      "replicas"
  )

  private val options: JsonReader.Options = JsonReader.Options.of(
      "partition",
      "leader",
      "replicas"
  )

  @Throws(IOException::class)
  override fun toJson(writer: JsonWriter, `value`: Partition?) {
    if (`value` == null) {
      writer.nullValue()
      return
    }
    writer
      .beginObject()
      .name("partition").apply {
        partitionAdapter.toJson(this, `value`.partition)
      }
      .name("leader").apply {
        leaderAdapter.toJson(this, `value`.leader)
      }
      .name("replicas").apply {
        replicasAdapter.toJson(this, `value`.replicas)
      }
      .endObject()
  }

  @Throws(IOException::class)
  override fun fromJson(reader: JsonReader): Partition? {
    if (reader.peek() == JsonReader.Token.NULL) return reader.nextNull()

    var partition: PartitionId? = null
    var leader: BrokerId? = null
    var replicas: List<Replica>? = null

    reader.beginObject()
    while (reader.hasNext()) {
      when (reader.selectName(options)) {
        0 -> {
          partition = partitionAdapter.fromJson(reader)
        }
        1 -> {
          leader = leaderAdapter.fromJson(reader)
        }
        2 -> {
          replicas = replicasAdapter.fromJson(reader)
        }
        -1 -> {
          reader.skipName()
          reader.skipValue()
        }
      }
    }
    reader.endObject()

    var errorBuilder: StringBuilder? = null
    if (partition == null) {
      errorBuilder = errorBuilder.appendNullableError("partition")
    }
    if (leader == null) {
      errorBuilder = errorBuilder.appendNullableError("leader")
    }
    if (replicas == null) {
      errorBuilder = errorBuilder.appendNullableError("replicas")
    }
    if (errorBuilder != null) {
      errorBuilder.append(" (at path ").append(reader.path).append(')')
      throw JsonDataException(errorBuilder.toString())
    }

    return Partition(
        partition = partition!!,
        leader = leader!!,
        replicas = replicas!!
    )
  }
}
