package org.http4k.connect.kafka.rest.v2

import dev.forkhandles.result4k.Result
import java.time.Duration
import kotlin.Array
import kotlin.Unit
import kotlin.collections.List
import org.http4k.connect.RemoteFailure
import org.http4k.connect.kafka.rest.KafkaRestConsumer
import org.http4k.connect.kafka.rest.model.Topic
import org.http4k.connect.kafka.rest.v2.action.consumer.CommitOffsets
import org.http4k.connect.kafka.rest.v2.action.consumer.ConsumeRecords
import org.http4k.connect.kafka.rest.v2.action.consumer.Delete
import org.http4k.connect.kafka.rest.v2.action.consumer.GetOffsets
import org.http4k.connect.kafka.rest.v2.action.consumer.SeekOffsets
import org.http4k.connect.kafka.rest.v2.action.consumer.SubscribeToTopics
import org.http4k.connect.kafka.rest.v2.model.CommitOffset
import org.http4k.connect.kafka.rest.v2.model.CommitOffsetsSet
import org.http4k.connect.kafka.rest.v2.model.PartitionOffsetRequest
import org.http4k.connect.kafka.rest.v2.model.RecordFormat
import org.http4k.connect.kafka.rest.v2.model.SeekOffset
import org.http4k.connect.kafka.rest.v2.model.TopicRecord

/**
 * @see org.http4k.connect.kafka.rest.v2.action.consumer.CommitOffsets
 */
public fun KafkaRestConsumer.commitOffsets(offsets: List<CommitOffset>): Result<Unit, RemoteFailure> = invoke(CommitOffsets(offsets))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.consumer.ConsumeRecords
 */
public fun KafkaRestConsumer.consumeRecords(format: RecordFormat, timeout: Duration? = null): Result<Array<TopicRecord>, RemoteFailure> = invoke(ConsumeRecords(format, timeout))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.consumer.Delete
 */
public fun KafkaRestConsumer.delete(): Result<Unit?, RemoteFailure> = invoke(Delete)

/**
 * @see org.http4k.connect.kafka.rest.v2.action.consumer.GetOffsets
 */
public fun KafkaRestConsumer.getOffsets(partitions: List<PartitionOffsetRequest>): Result<CommitOffsetsSet, RemoteFailure> = invoke(GetOffsets(partitions))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.consumer.SeekOffsets
 */
public fun KafkaRestConsumer.seekOffsets(offsets: List<SeekOffset>): Result<Unit, RemoteFailure> = invoke(SeekOffsets(offsets))

/**
 * @see org.http4k.connect.kafka.rest.v2.action.consumer.SubscribeToTopics
 */
public fun KafkaRestConsumer.subscribeToTopics(topics: List<Topic>): Result<Unit, RemoteFailure> = invoke(SubscribeToTopics(topics))
