/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.openai.auth;

import java.time.Clock;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.connect.openai.auth.PluginAuth;
import org.http4k.connect.openai.auth.PluginToken;
import org.http4k.connect.openai.auth.StaticOpenAiClientValidator;
import org.http4k.connect.openai.auth.oauth.OAuthMachinery;
import org.http4k.connect.openai.model.AuthedSystem;
import org.http4k.connect.openai.model.VerificationToken;
import org.http4k.core.ContentType;
import org.http4k.core.Credentials;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.core.Uri;
import org.http4k.routing.RoutingHttpHandler;
import org.http4k.routing.RoutingKt;
import org.http4k.security.AccessToken;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthRequestTracking;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientValidator;
import org.http4k.security.oauth.server.OAuthServer;
import org.http4k.security.oauth.server.refreshtoken.RefreshTokens;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00190\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/http4k/connect/openai/auth/OAuth;", "Lorg/http4k/connect/openai/auth/PluginAuth;", "baseUrl", "Lorg/http4k/core/Uri;", "tokens", "", "Lorg/http4k/connect/openai/model/AuthedSystem;", "Lorg/http4k/connect/openai/model/VerificationToken;", "openAiClientCredentials", "Lorg/http4k/core/Credentials;", "storage", "Lorg/http4k/connect/openai/auth/oauth/OAuthMachinery;", "clock", "Ljava/time/Clock;", "scope", "", "contentType", "Lorg/http4k/core/ContentType;", "(Lorg/http4k/core/Uri;Ljava/util/Map;Lorg/http4k/core/Credentials;Lorg/http4k/connect/openai/auth/oauth/OAuthMachinery;Ljava/time/Clock;Ljava/lang/String;Lorg/http4k/core/ContentType;)V", "authRoutes", "", "Lorg/http4k/routing/RoutingHttpHandler;", "getAuthRoutes", "()Ljava/util/List;", "manifestDescription", "", "getManifestDescription", "()Ljava/util/Map;", "securityFilter", "Lorg/http4k/core/Filter;", "getSecurityFilter", "()Lorg/http4k/core/Filter;", "server", "Lorg/http4k/security/oauth/server/OAuthServer;", "http4k-connect-openai-plugin"})
public final class OAuth
implements PluginAuth {
    @NotNull
    private final Map<String, Object> manifestDescription;
    @NotNull
    private final Filter securityFilter;
    @NotNull
    private final OAuthServer server;
    @NotNull
    private final List<RoutingHttpHandler> authRoutes;

    public OAuth(@NotNull Uri baseUrl, @NotNull Map<AuthedSystem, VerificationToken> tokens, @NotNull Credentials openAiClientCredentials, @NotNull OAuthMachinery storage, @NotNull Clock clock, @NotNull String scope, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)openAiClientCredentials, (String)"openAiClientCredentials");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"oauth"), TuplesKt.to((Object)"client_url", (Object)baseUrl.path("/authorize")), TuplesKt.to((Object)"scope", (Object)scope), TuplesKt.to((Object)"authorization_url", (Object)baseUrl.path("/token")), TuplesKt.to((Object)"authorization_content_type", (Object)contentType), TuplesKt.to((Object)"verification_tokens", tokens)};
        this.manifestDescription = MapsKt.mapOf((Pair[])objectArray);
        this.securityFilter = new PluginToken.Bearer((Function1<? super AccessToken, Boolean>)((Function1)new Function1<AccessToken, Boolean>((Object)storage){

            @NotNull
            public final Boolean invoke(@NotNull AccessToken p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((OAuthMachinery)this.receiver).validate(p0);
            }
        })).getSecurityFilter();
        this.server = new OAuthServer("/token", (AuthRequestTracking)storage, (ClientValidator)new StaticOpenAiClientValidator(openAiClientCredentials, scope), (AuthorizationCodes)storage, (AccessTokens)storage, clock, null, null, null, null, (RefreshTokens)storage, null, null, null, 15296, null);
        objectArray = new RoutingHttpHandler[]{this.server.getTokenRoute(), RoutingKt.bind((String)"/authorize", (Method)Method.GET).to(Http4kKt.then((Filter)this.server.getAuthenticationStart(), (Function1)((Function1)this.server.getAuthenticationComplete())))};
        this.authRoutes = CollectionsKt.listOf((Object[])objectArray);
    }

    public /* synthetic */ OAuth(Uri uri, Map map, Credentials credentials, OAuthMachinery oAuthMachinery, Clock clock, String string, ContentType contentType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            string = "";
        }
        if ((n & 0x40) != 0) {
            contentType = ContentType.Companion.getAPPLICATION_JSON().withNoDirectives();
        }
        this(uri, map, credentials, oAuthMachinery, clock, string, contentType);
    }

    @Override
    @NotNull
    public Map<String, Object> getManifestDescription() {
        return this.manifestDescription;
    }

    @Override
    @NotNull
    public Filter getSecurityFilter() {
        return this.securityFilter;
    }

    @Override
    @NotNull
    public List<RoutingHttpHandler> getAuthRoutes() {
        return this.authRoutes;
    }
}

