/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.openai.auth;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Credentials;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.ClientValidator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/http4k/connect/openai/auth/StaticOpenAiClientValidator;", "Lorg/http4k/security/oauth/server/ClientValidator;", "openAiClientCredentials", "Lorg/http4k/core/Credentials;", "scope", "", "(Lorg/http4k/core/Credentials;Ljava/lang/String;)V", "validateClientId", "", "request", "Lorg/http4k/core/Request;", "clientId", "Lorg/http4k/security/oauth/server/ClientId;", "validateCredentials", "clientSecret", "validateRedirection", "redirectionUri", "Lorg/http4k/core/Uri;", "validateScopes", "scopes", "", "http4k-connect-openai-plugin"})
public final class StaticOpenAiClientValidator
implements ClientValidator {
    @NotNull
    private final Credentials openAiClientCredentials;
    @NotNull
    private final String scope;

    public StaticOpenAiClientValidator(@NotNull Credentials openAiClientCredentials, @NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)openAiClientCredentials, (String)"openAiClientCredentials");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.openAiClientCredentials = openAiClientCredentials;
        this.scope = scope;
    }

    public boolean validateClientId(@NotNull Request request, @NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        return Intrinsics.areEqual((Object)clientId, (Object)new ClientId(this.openAiClientCredentials.getUser()));
    }

    public boolean validateCredentials(@NotNull Request request, @NotNull ClientId clientId, @NotNull String clientSecret) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        return Intrinsics.areEqual((Object)new Credentials(clientId.getValue(), clientSecret), (Object)this.openAiClientCredentials);
    }

    public boolean validateRedirection(@NotNull Request request, @NotNull ClientId clientId, @NotNull Uri redirectionUri) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)redirectionUri, (String)"redirectionUri");
        return Intrinsics.areEqual((Object)redirectionUri, (Object)Uri.Companion.of("https://chat.openai.com/aip/plugin-some_plugin_id/oauth/callback"));
    }

    public boolean validateScopes(@NotNull Request request, @NotNull ClientId clientId, @NotNull List<String> scopes) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        return Intrinsics.areEqual(scopes, (Object)CollectionsKt.listOf((Object)this.scope));
    }
}

