/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.openai.auth.oauth;

import dev.forkhandles.result4k.Success;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.connect.openai.auth.oauth.SecureStrings;
import org.http4k.connect.storage.Storage;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.oauth.server.AuthorizationCodeDetails;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"StorageAuthorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "storage", "Lorg/http4k/connect/storage/Storage;", "Lorg/http4k/security/oauth/server/AuthorizationCodeDetails;", "clock", "Ljava/time/Clock;", "strings", "Lorg/http4k/connect/openai/auth/oauth/SecureStrings;", "validity", "Ljava/time/Duration;", "http4k-connect-openai-plugin"})
public final class StorageAuthorizationCodesKt {
    @NotNull
    public static final AuthorizationCodes StorageAuthorizationCodes(@NotNull Storage<AuthorizationCodeDetails> storage, @NotNull Clock clock, @NotNull SecureStrings strings, @NotNull Duration validity) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)validity, (String)"validity");
        return new AuthorizationCodes(strings, storage, clock, validity){
            final /* synthetic */ SecureStrings $strings;
            final /* synthetic */ Storage<AuthorizationCodeDetails> $storage;
            final /* synthetic */ Clock $clock;
            final /* synthetic */ Duration $validity;
            {
                this.$strings = $strings;
                this.$storage = $storage;
                this.$clock = $clock;
                this.$validity = $validity;
            }

            @NotNull
            public Success<AuthorizationCode> create(@NotNull Request request, @NotNull AuthRequest authRequest, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                AuthorizationCode authorizationCode = new AuthorizationCode((String)this.$strings.invoke());
                Storage<AuthorizationCodeDetails> storage = this.$storage;
                Clock clock = this.$clock;
                Duration duration = this.$validity;
                AuthorizationCode it = authorizationCode;
                boolean bl = false;
                String string = it.getValue();
                ClientId clientId = authRequest.getClient();
                Uri uri = authRequest.getRedirectUri();
                Intrinsics.checkNotNull((Object)uri);
                Instant instant = clock.instant().plus(duration);
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant() + validity");
                storage.set(string, (Object)new AuthorizationCodeDetails(clientId, uri, instant, null, false, authRequest.getResponseType(), null, 64, null));
                AuthorizationCode authorizationCode2 = authorizationCode;
                return new Success((Object)authorizationCode2);
            }

            @NotNull
            public AuthorizationCodeDetails detailsFor(@NotNull AuthorizationCode code) {
                Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                AuthorizationCodeDetails authorizationCodeDetails = (AuthorizationCodeDetails)this.$storage.get(code.getValue());
                if (authorizationCodeDetails == null) {
                    throw new IllegalStateException("unknown code".toString());
                }
                AuthorizationCodeDetails authorizationCodeDetails2 = authorizationCodeDetails;
                Storage<AuthorizationCodeDetails> storage = this.$storage;
                AuthorizationCodeDetails it = authorizationCodeDetails2;
                boolean bl = false;
                storage.remove(code.getValue());
                return authorizationCodeDetails2;
            }
        };
    }
}

