/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.openai.auth.oauth;

import dev.forkhandles.result4k.Result;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.connect.openai.auth.oauth.OAuthMachinery;
import org.http4k.connect.openai.auth.oauth.SecureStrings;
import org.http4k.connect.openai.auth.oauth.StorageAccessTokensKt;
import org.http4k.connect.openai.auth.oauth.StorageAuthRequestTrackingKt;
import org.http4k.connect.openai.auth.oauth.StorageAuthorizationCodesKt;
import org.http4k.connect.openai.auth.oauth.StorageProvider;
import org.http4k.connect.openai.auth.oauth.StorageRefreshTokensKt;
import org.http4k.connect.storage.Storage;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.security.AccessToken;
import org.http4k.security.oauth.core.RefreshToken;
import org.http4k.security.oauth.server.AccessTokenError;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthRequestTracking;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.oauth.server.AuthorizationCodeAlreadyUsed;
import org.http4k.security.oauth.server.AuthorizationCodeDetails;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.TokenRequest;
import org.http4k.security.oauth.server.UserRejectedRequest;
import org.http4k.security.oauth.server.accesstoken.AuthorizationCodeAccessTokenRequest;
import org.http4k.security.oauth.server.refreshtoken.RefreshTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"StorageOAuthMachinery", "Lorg/http4k/connect/openai/auth/oauth/OAuthMachinery;", "storageProvider", "Lorg/http4k/connect/openai/auth/oauth/StorageProvider;", "strings", "Lorg/http4k/connect/openai/auth/oauth/SecureStrings;", "validity", "Ljava/time/Duration;", "cookieDomain", "", "clock", "Ljava/time/Clock;", "http4k-connect-openai-plugin"})
public final class StorageOAuthFlowTrackingAndAssignmentKt {
    @NotNull
    public static final OAuthMachinery StorageOAuthMachinery(@NotNull StorageProvider storageProvider, @NotNull SecureStrings strings, @NotNull Duration validity, @NotNull String cookieDomain, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)storageProvider, (String)"storageProvider");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)validity, (String)"validity");
        Intrinsics.checkNotNullParameter((Object)cookieDomain, (String)"cookieDomain");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Storage tokenStorage = storageProvider.invoke();
        AccessTokens accessTokens = StorageAccessTokensKt.StorageAccessTokens(tokenStorage, strings, validity, clock);
        return new OAuthMachinery(accessTokens, storageProvider, clock, strings, validity, cookieDomain, tokenStorage){
            private final /* synthetic */ AccessTokens $$delegate_0;
            private final /* synthetic */ AuthorizationCodes $$delegate_1;
            private final /* synthetic */ AuthRequestTracking $$delegate_2;
            private final /* synthetic */ RefreshTokens $$delegate_3;
            final /* synthetic */ Clock $clock;
            final /* synthetic */ Storage<Instant> $tokenStorage;
            {
                this.$clock = $clock;
                this.$tokenStorage = $tokenStorage;
                this.$$delegate_0 = $accessTokens;
                this.$$delegate_1 = StorageAuthorizationCodesKt.StorageAuthorizationCodes($storageProvider.invoke(), $clock, $strings, $validity);
                this.$$delegate_2 = StorageAuthRequestTrackingKt.StorageAuthRequestTracking($storageProvider.invoke(), $cookieDomain, $clock, $strings, $validity);
                this.$$delegate_3 = StorageRefreshTokensKt.StorageRefreshTokens($storageProvider.invoke(), $accessTokens);
            }

            @NotNull
            public Result<AccessToken, AccessTokenError> create(@NotNull ClientId clientId, @NotNull TokenRequest tokenRequest) {
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
                return this.$$delegate_0.create(clientId, tokenRequest);
            }

            @NotNull
            public Result<AccessToken, AuthorizationCodeAlreadyUsed> create(@NotNull ClientId clientId, @NotNull AuthorizationCodeAccessTokenRequest tokenRequest, @NotNull AuthorizationCode authorizationCode) {
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
                Intrinsics.checkNotNullParameter((Object)authorizationCode, (String)"authorizationCode");
                return this.$$delegate_0.create(clientId, tokenRequest, authorizationCode);
            }

            @NotNull
            public Result<AuthorizationCode, UserRejectedRequest> create(@NotNull Request request, @NotNull AuthRequest authRequest, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return this.$$delegate_1.create(request, authRequest, response);
            }

            @NotNull
            public AuthorizationCodeDetails detailsFor(@NotNull AuthorizationCode code) {
                Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                return this.$$delegate_1.detailsFor(code);
            }

            @Nullable
            public AuthRequest resolveAuthRequest(@NotNull Request request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                return this.$$delegate_2.resolveAuthRequest(request);
            }

            @NotNull
            public Response trackAuthRequest(@NotNull Request request, @NotNull AuthRequest authRequest, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return this.$$delegate_2.trackAuthRequest(request, authRequest, response);
            }

            @NotNull
            public Result<AccessToken, AccessTokenError> refreshAccessToken(@NotNull ClientId clientId, @NotNull TokenRequest tokenRequest, @NotNull RefreshToken refreshToken) {
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
                Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
                return this.$$delegate_3.refreshAccessToken(clientId, tokenRequest, refreshToken);
            }

            public boolean validate(@NotNull AccessToken accessToken) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
                Instant instant = (Instant)this.$tokenStorage.get(accessToken.getValue());
                if (instant != null) {
                    boolean bl2;
                    Instant instant2 = instant;
                    Clock clock = this.$clock;
                    Storage<Instant> storage = this.$tokenStorage;
                    Instant it = instant2;
                    boolean bl3 = false;
                    boolean it2 = bl2 = clock.instant().isBefore(it);
                    boolean bl4 = false;
                    if (!it2) {
                        storage.remove(accessToken.getValue());
                    }
                    bl = bl2;
                } else {
                    bl = false;
                }
                return bl;
            }
        };
    }
}

