/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.openai.auth.oauth;

import java.time.Clock;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.connect.openai.auth.PluginAuth;
import org.http4k.connect.openai.auth.oauth.OAuthPluginConfig;
import org.http4k.connect.openai.auth.oauth.PrincipalChallenge;
import org.http4k.connect.openai.auth.oauth.PrincipalStore;
import org.http4k.connect.openai.auth.oauth.PrincipalTokens;
import org.http4k.connect.openai.auth.oauth.internal.PluginAccessTokensKt;
import org.http4k.connect.openai.auth.oauth.internal.PluginAuthorizationCodesKt;
import org.http4k.connect.openai.auth.oauth.internal.PluginSecurityFilterKt;
import org.http4k.connect.openai.auth.oauth.internal.StaticOpenAiClientValidatorKt;
import org.http4k.connect.openai.model.AuthedSystem;
import org.http4k.connect.openai.model.VerificationToken;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.routing.RoutingHttpHandler;
import org.http4k.routing.RoutingKt;
import org.http4k.security.oauth.server.AuthRequestTracking;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.OAuthServer;
import org.http4k.security.oauth.server.refreshtoken.RefreshTokens;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003Bc\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/http4k/connect/openai/auth/oauth/OAuth;", "Principal", "", "Lorg/http4k/connect/openai/auth/PluginAuth;", "config", "Lorg/http4k/connect/openai/auth/oauth/OAuthPluginConfig;", "principalTokens", "Lorg/http4k/connect/openai/auth/oauth/PrincipalTokens;", "principalChallenge", "Lorg/http4k/connect/openai/auth/oauth/PrincipalChallenge;", "principalStore", "Lorg/http4k/connect/openai/auth/oauth/PrincipalStore;", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "authRequestTracking", "Lorg/http4k/security/oauth/server/AuthRequestTracking;", "tokens", "", "Lorg/http4k/connect/openai/model/AuthedSystem;", "Lorg/http4k/connect/openai/model/VerificationToken;", "clock", "Ljava/time/Clock;", "(Lorg/http4k/connect/openai/auth/oauth/OAuthPluginConfig;Lorg/http4k/connect/openai/auth/oauth/PrincipalTokens;Lorg/http4k/connect/openai/auth/oauth/PrincipalChallenge;Lorg/http4k/connect/openai/auth/oauth/PrincipalStore;Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AuthRequestTracking;Ljava/util/Map;Ljava/time/Clock;)V", "authRoutes", "", "Lorg/http4k/routing/RoutingHttpHandler;", "getAuthRoutes", "()Ljava/util/List;", "manifestDescription", "", "getManifestDescription", "()Ljava/util/Map;", "securityFilter", "Lorg/http4k/core/Filter;", "getSecurityFilter", "()Lorg/http4k/core/Filter;", "server", "Lorg/http4k/security/oauth/server/OAuthServer;", "http4k-connect-openai-plugin"})
public final class OAuth<Principal>
implements PluginAuth {
    @NotNull
    private final Map<String, Object> manifestDescription;
    @NotNull
    private final OAuthServer server;
    @NotNull
    private final Filter securityFilter;
    @NotNull
    private final List<RoutingHttpHandler> authRoutes;

    public OAuth(@NotNull OAuthPluginConfig config, @NotNull PrincipalTokens<Principal> principalTokens, @NotNull PrincipalChallenge<Principal> principalChallenge, @NotNull PrincipalStore<Principal> principalStore, @NotNull AuthorizationCodes authorizationCodes, @NotNull AuthRequestTracking authRequestTracking, @NotNull Map<AuthedSystem, VerificationToken> tokens, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(principalTokens, (String)"principalTokens");
        Intrinsics.checkNotNullParameter(principalChallenge, (String)"principalChallenge");
        Intrinsics.checkNotNullParameter(principalStore, (String)"principalStore");
        Intrinsics.checkNotNullParameter((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkNotNullParameter((Object)authRequestTracking, (String)"authRequestTracking");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"oauth"), TuplesKt.to((Object)"client_url", (Object)config.getProviderConfig().getAuthPath()), TuplesKt.to((Object)"scope", (Object)config.getScope()), TuplesKt.to((Object)"authorization_url", (Object)config.getProviderConfig().getTokenPath()), TuplesKt.to((Object)"authorization_content_type", (Object)config.getContentType()), TuplesKt.to((Object)"verification_tokens", tokens)};
        this.manifestDescription = MapsKt.mapOf((Pair[])objectArray);
        this.server = new OAuthServer(config.getProviderConfig().getTokenPath(), authRequestTracking, StaticOpenAiClientValidatorKt.StaticOpenAiClientValidator(config), PluginAuthorizationCodesKt.PluginAuthorizationCodes(authorizationCodes, principalStore, principalChallenge), PluginAccessTokensKt.PluginAccessTokens(principalStore, principalTokens), clock, null, null, null, null, (RefreshTokens)principalTokens, null, null, null, 15296, null);
        this.securityFilter = PluginSecurityFilterKt.PluginSecurityFilter(principalTokens);
        objectArray = new RoutingHttpHandler[]{this.server.getTokenRoute(), RoutingKt.bind((String)config.getProviderConfig().getAuthPath(), (Method)Method.GET).to(Http4kKt.then((Filter)this.server.getAuthenticationStart(), principalChallenge.getChallenge())), RoutingKt.bind((String)config.getProviderConfig().getAuthPath(), (Method)Method.POST).to(Http4kKt.then((Filter)Http4kKt.then((Filter)this.server.getAuthenticationStart(), (Filter)principalChallenge.getHandleChallenge()), (Function1)((Function1)this.server.getAuthenticationComplete())))};
        this.authRoutes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Map<String, Object> getManifestDescription() {
        return this.manifestDescription;
    }

    @Override
    @NotNull
    public Filter getSecurityFilter() {
        return this.securityFilter;
    }

    @Override
    @NotNull
    public List<RoutingHttpHandler> getAuthRoutes() {
        return this.authRoutes;
    }
}

