/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.openai.auth.oauth.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.connect.openai.auth.oauth.OAuthPluginConfig;
import org.http4k.core.Credentials;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.ClientValidator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"StaticOpenAiClientValidator", "Lorg/http4k/security/oauth/server/ClientValidator;", "config", "Lorg/http4k/connect/openai/auth/oauth/OAuthPluginConfig;", "http4k-connect-openai-plugin"})
public final class StaticOpenAiClientValidatorKt {
    @NotNull
    public static final ClientValidator StaticOpenAiClientValidator(@NotNull OAuthPluginConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new ClientValidator(config){
            final /* synthetic */ OAuthPluginConfig $config;
            {
                this.$config = $config;
            }

            public boolean validateClientId(@NotNull Request request, @NotNull ClientId clientId) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                return Intrinsics.areEqual((Object)clientId, (Object)new ClientId(this.$config.getProviderConfig().getCredentials().getUser()));
            }

            public boolean validateCredentials(@NotNull Request request, @NotNull ClientId clientId, @NotNull String clientSecret) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
                return Intrinsics.areEqual((Object)new Credentials(clientId.getValue(), clientSecret), (Object)this.$config.getProviderConfig().getCredentials());
            }

            public boolean validateRedirection(@NotNull Request request, @NotNull ClientId clientId, @NotNull Uri redirectionUri) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter((Object)redirectionUri, (String)"redirectionUri");
                return this.$config.getRedirectionUris().contains(redirectionUri);
            }

            public boolean validateScopes(@NotNull Request request, @NotNull ClientId clientId, @NotNull List<String> scopes) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
                return Intrinsics.areEqual(scopes, (Object)CollectionsKt.listOf((Object)this.$config.getScope()));
            }
        };
    }
}

