/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.storage;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.http4k.connect.storage.Storage;
import org.http4k.core.Uri;
import org.http4k.format.AutoMarshalling;
import org.http4k.format.Moshi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u00020\u0006\u001a>\u0010\u0000\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u0001H\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u00020\f\u001a9\u0010\u0000\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u0001H\u0002H\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003*\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0086\b\u001a\u0012\u0010\u000f\u001a\n \b*\u0004\u0018\u00010\u00100\u0010*\u00020\n\u00a8\u0006\u0011"}, d2={"Redis", "Lorg/http4k/connect/storage/Storage;", "T", "", "Lorg/http4k/connect/storage/Storage$Companion;", "redis", "Lio/lettuce/core/api/sync/RedisCommands;", "", "kotlin.jvm.PlatformType", "uri", "Lorg/http4k/core/Uri;", "codec", "Lio/lettuce/core/codec/RedisCodec;", "autoMarshalling", "Lorg/http4k/format/AutoMarshalling;", "asRedis", "Lio/lettuce/core/RedisURI;", "http4k-connect-storage-redis"})
public final class RedisStorageKt {
    public static final /* synthetic */ <T> Storage<T> Redis(Storage.Companion $this$Redis, Uri uri, AutoMarshalling autoMarshalling) {
        Intrinsics.checkNotNullParameter((Object)$this$Redis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)autoMarshalling, (String)"autoMarshalling");
        boolean $i$f$Redis = false;
        boolean $i$f$AutoRedisCodec = false;
        Intrinsics.needClassReification();
        return RedisStorageKt.Redis($this$Redis, uri, (RedisCodec)new RedisCodec<String, T>(autoMarshalling){
            final /* synthetic */ AutoMarshalling $autoMarshalling;
            {
                this.$autoMarshalling = $autoMarshalling;
            }

            @NotNull
            public String decodeKey(@NotNull ByteBuffer bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                String string = StandardCharsets.UTF_8.decode(bytes).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UTF_8.decode(bytes).toString()");
                return string;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public T decodeValue(@NotNull ByteBuffer bytes) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                AutoMarshalling autoMarshalling = this.$autoMarshalling;
                String string = StandardCharsets.UTF_8.decode(bytes).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UTF_8.decode(bytes).toString()");
                String input$iv = string;
                boolean $i$f$stringAsA = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return (T)this_$iv.asA(input$iv, Reflection.getOrCreateKotlinClass(Object.class));
            }

            public ByteBuffer encodeKey(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return new StringCodec().encodeKey(key);
            }

            public ByteBuffer encodeValue(@NotNull T value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                return StandardCharsets.UTF_8.encode(this.$autoMarshalling.asFormatString(value));
            }
        });
    }

    public static /* synthetic */ Storage Redis$default(Storage.Companion $this$Redis_u24default, Uri uri, AutoMarshalling autoMarshalling, int n, Object object) {
        if ((n & 2) != 0) {
            autoMarshalling = (AutoMarshalling)Moshi.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)$this$Redis_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)autoMarshalling, (String)"autoMarshalling");
        boolean $i$f$Redis = false;
        boolean $i$f$AutoRedisCodec = false;
        Intrinsics.needClassReification();
        return RedisStorageKt.Redis($this$Redis_u24default, uri, (RedisCodec)new /* invalid duplicate definition of identical inner class */);
    }

    @NotNull
    public static final <T> Storage<T> Redis(@NotNull Storage.Companion $this$Redis, @NotNull Uri uri, @NotNull RedisCodec<String, T> codec) {
        Intrinsics.checkNotNullParameter((Object)$this$Redis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        RedisCommands redisCommands = RedisClient.create((RedisURI)RedisStorageKt.asRedis(uri)).connect(codec).sync();
        Intrinsics.checkNotNullExpressionValue((Object)redisCommands, (String)"create(uri.asRedis()).connect(codec).sync()");
        return RedisStorageKt.Redis($this$Redis, redisCommands);
    }

    @NotNull
    public static final <T> Storage<T> Redis(@NotNull Storage.Companion $this$Redis, @NotNull RedisCommands<String, T> redis) {
        Intrinsics.checkNotNullParameter((Object)$this$Redis, (String)"<this>");
        Intrinsics.checkNotNullParameter(redis, (String)"redis");
        return new Storage<T>(redis){
            private final long lifetime;
            final /* synthetic */ RedisCommands<String, T> $redis;
            {
                this.$redis = $redis;
                this.lifetime = TimeUnit.HOURS.toSeconds(1L);
            }

            @Nullable
            public T get(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return (T)this.$redis.get((Object)key);
            }

            public void set(@NotNull String key, @NotNull T data) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                String result = this.$redis.set((Object)key, data, SetArgs.Builder.ex((long)this.lifetime));
                if (!Intrinsics.areEqual((Object)result, (Object)"OK")) {
                    throw new RuntimeException(result);
                }
            }

            public boolean remove(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Object[] objectArray = new String[]{key};
                Long l = this.$redis.del(objectArray);
                long l2 = 1L;
                return l != null && l == l2;
            }

            public boolean removeAll(@NotNull String keyPrefix) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
                List keys = this.$redis.keys((Object)Intrinsics.stringPlus((String)keyPrefix, (Object)"*"));
                if (keys.isEmpty()) {
                    bl = false;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)keys, (String)"keys");
                    Collection $this$toTypedArray$iv = keys;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] stringArray2 = stringArray;
                    this.$redis.del((Object[])Arrays.copyOf(stringArray2, stringArray2.length));
                    bl = true;
                }
                return bl;
            }

            @NotNull
            public Set<String> keySet(@NotNull String keyPrefix) {
                Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
                List list = this.$redis.keys((Object)Intrinsics.stringPlus((String)keyPrefix, (Object)"*"));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"redis.keys(\"$keyPrefix*\")");
                return CollectionsKt.toSet((Iterable)list);
            }
        };
    }

    public static final RedisURI asRedis(@NotNull Uri $this$asRedis) {
        Intrinsics.checkNotNullParameter((Object)$this$asRedis, (String)"<this>");
        return RedisURI.create((URI)new URI($this$asRedis.toString()));
    }
}

