/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.storage;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.connect.storage.Storage;
import org.http4k.core.Uri;
import org.http4k.format.AutoMarshalling;
import org.http4k.format.Moshi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u001a>\u0010\u0000\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u0001H\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u00020\u000e\u001a9\u0010\u0000\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u0001H\u0002H\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0086\b\u001a\u0012\u0010\u0011\u001a\n \n*\u0004\u0018\u00010\u00120\u0012*\u00020\f\u00a8\u0006\u0013"}, d2={"Redis", "Lorg/http4k/connect/storage/Storage;", "T", "", "Lorg/http4k/connect/storage/Storage$Companion;", "redis", "Lio/lettuce/core/api/sync/RedisCommands;", "", "ttl", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "uri", "Lorg/http4k/core/Uri;", "codec", "Lio/lettuce/core/codec/RedisCodec;", "autoMarshalling", "Lorg/http4k/format/AutoMarshalling;", "asRedis", "Lio/lettuce/core/RedisURI;", "http4k-connect-storage-redis"})
@SourceDebugExtension(value={"SMAP\nRedisStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisStorage.kt\norg/http4k/connect/storage/RedisStorageKt\n+ 2 AutoCodec.kt\norg/http4k/connect/storage/AutoCodecKt\n*L\n1#1,57:1\n9#2,9:58\n*S KotlinDebug\n*F\n+ 1 RedisStorage.kt\norg/http4k/connect/storage/RedisStorageKt\n*L\n19#1:58,9\n*E\n"})
public final class RedisStorageKt {
    public static final /* synthetic */ <T> Storage<T> Redis(Storage.Companion $this$Redis, Uri uri, AutoMarshalling autoMarshalling) {
        Intrinsics.checkNotNullParameter((Object)$this$Redis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)autoMarshalling, (String)"autoMarshalling");
        boolean $i$f$Redis = false;
        boolean $i$f$AutoRedisCodec = false;
        Intrinsics.needClassReification();
        return RedisStorageKt.Redis($this$Redis, uri, (RedisCodec)new RedisCodec<String, T>(autoMarshalling){
            final /* synthetic */ AutoMarshalling $autoMarshalling;
            {
                this.$autoMarshalling = $autoMarshalling;
            }

            @NotNull
            public String decodeKey(@NotNull ByteBuffer bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                String string = StandardCharsets.UTF_8.decode(bytes).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public T decodeValue(@NotNull ByteBuffer bytes) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                AutoMarshalling autoMarshalling = this.$autoMarshalling;
                String string = StandardCharsets.UTF_8.decode(bytes).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String input$iv = string;
                boolean $i$f$stringAsA = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return (T)this_$iv.asA(input$iv, Reflection.getOrCreateKotlinClass(Object.class));
            }

            public ByteBuffer encodeKey(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return new StringCodec().encodeKey(key);
            }

            public ByteBuffer encodeValue(@NotNull T value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                return StandardCharsets.UTF_8.encode(this.$autoMarshalling.asFormatString(value));
            }
        });
    }

    public static /* synthetic */ Storage Redis$default(Storage.Companion $this$Redis_u24default, Uri uri, AutoMarshalling autoMarshalling, int n, Object object) {
        if ((n & 2) != 0) {
            autoMarshalling = (AutoMarshalling)Moshi.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)$this$Redis_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)autoMarshalling, (String)"autoMarshalling");
        boolean $i$f$Redis = false;
        boolean $i$f$AutoRedisCodec = false;
        Intrinsics.needClassReification();
        return RedisStorageKt.Redis($this$Redis_u24default, uri, (RedisCodec)new /* invalid duplicate definition of identical inner class */);
    }

    @NotNull
    public static final <T> Storage<T> Redis(@NotNull Storage.Companion $this$Redis, @NotNull Uri uri, @NotNull RedisCodec<String, T> codec) {
        Intrinsics.checkNotNullParameter((Object)$this$Redis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        RedisCommands redisCommands = RedisClient.create((RedisURI)RedisStorageKt.asRedis(uri)).connect(codec).sync();
        Intrinsics.checkNotNullExpressionValue((Object)redisCommands, (String)"sync(...)");
        return RedisStorageKt.Redis$default($this$Redis, redisCommands, null, 2, null);
    }

    @NotNull
    public static final <T> Storage<T> Redis(@NotNull Storage.Companion $this$Redis, @NotNull RedisCommands<String, T> redis, @NotNull Duration ttl) {
        Intrinsics.checkNotNullParameter((Object)$this$Redis, (String)"<this>");
        Intrinsics.checkNotNullParameter(redis, (String)"redis");
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        return new Storage<T>(redis, ttl){
            final /* synthetic */ RedisCommands<String, T> $redis;
            final /* synthetic */ Duration $ttl;
            {
                this.$redis = $redis;
                this.$ttl = $ttl;
            }

            @Nullable
            public T get(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return (T)this.$redis.get((Object)key);
            }

            public void set(@NotNull String key, @NotNull T data) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                String result = this.$redis.set((Object)key, data, SetArgs.Builder.ex((long)this.$ttl.toSeconds()));
                if (!Intrinsics.areEqual((Object)result, (Object)"OK")) {
                    throw new RuntimeException(result);
                }
            }

            public boolean remove(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Object[] objectArray = new String[]{key};
                Long l = this.$redis.del(objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"del(...)");
                return ((Number)l).longValue() >= 1L;
            }

            public boolean removeAll(@NotNull String keyPrefix) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
                List keys = this.$redis.keys((Object)(keyPrefix + '*'));
                if (keys.isEmpty()) {
                    bl = false;
                } else {
                    Intrinsics.checkNotNull((Object)keys);
                    Collection $this$toTypedArray$iv = keys;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    this.$redis.del((Object[])Arrays.copyOf(stringArray, stringArray.length));
                    bl = true;
                }
                return bl;
            }

            @NotNull
            public Set<String> keySet(@NotNull String keyPrefix) {
                Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
                List list = this.$redis.keys((Object)(keyPrefix + '*'));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"keys(...)");
                return CollectionsKt.toSet((Iterable)list);
            }

            public void minusAssign(@NotNull String key) {
                Storage.DefaultImpls.minusAssign((Storage)this, (String)key);
            }
        };
    }

    public static /* synthetic */ Storage Redis$default(Storage.Companion companion, RedisCommands redisCommands, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofHours(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofHours(...)");
            duration = duration2;
        }
        return RedisStorageKt.Redis(companion, redisCommands, duration);
    }

    public static final RedisURI asRedis(@NotNull Uri $this$asRedis) {
        Intrinsics.checkNotNullParameter((Object)$this$asRedis, (String)"<this>");
        return RedisURI.create((URI)new URI($this$asRedis.toString()));
    }
}

