/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.storage;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.connect.storage.RedisStorageKt;
import org.http4k.connect.storage.Storage;
import org.http4k.core.Uri;
import org.http4k.format.AutoMarshalling;
import org.http4k.format.Moshi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aR\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u0001H\u0002H\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0014\b\n\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\f0\u000bH\u0086\b\u00f8\u0001\u0000\u001aT\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u0001H\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u00020\u000e2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\f0\u000b\u001a8\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0004*\u00020\u00052\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u00020\u00112\b\b\u0002\u0010\n\u001a\u00020\f\u001aD\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0004*\u00020\u00052\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u00020\u00112\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\f0\u000b\u001a\u0017\u0010\u0013\u001a\n \u0003*\u0004\u0018\u00010\u00140\u0014*\u00020\u0007\u00a2\u0006\u0002\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"Redis", "Lorg/http4k/connect/storage/Storage;", "T", "kotlin.jvm.PlatformType", "", "Lorg/http4k/connect/storage/Storage$Companion;", "uri", "Lorg/http4k/core/Uri;", "autoMarshalling", "Lorg/http4k/format/AutoMarshalling;", "ttl", "Lkotlin/Function1;", "Ljava/time/Duration;", "codec", "Lio/lettuce/core/codec/RedisCodec;", "", "redis", "Lio/lettuce/core/api/sync/RedisCommands;", "RedisWithDynamicTtl", "asRedis", "Lio/lettuce/core/RedisURI;", "(Lorg/http4k/core/Uri;)Lio/lettuce/core/RedisURI;", "http4k-connect-storage-redis"})
@SourceDebugExtension(value={"SMAP\nRedisStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisStorage.kt\norg/http4k/connect/storage/RedisStorageKt\n+ 2 AutoCodec.kt\norg/http4k/connect/storage/AutoCodecKt\n*L\n1#1,62:1\n9#2,9:63\n*S KotlinDebug\n*F\n+ 1 RedisStorage.kt\norg/http4k/connect/storage/RedisStorageKt\n*L\n19#1:63,9\n*E\n"})
public final class RedisStorageKt {
    public static final /* synthetic */ <T> Storage<T> Redis(Storage.Companion $this$Redis, Uri uri, AutoMarshalling autoMarshalling, Function1<? super T, Duration> ttl) {
        Intrinsics.checkNotNullParameter((Object)$this$Redis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)autoMarshalling, (String)"autoMarshalling");
        Intrinsics.checkNotNullParameter(ttl, (String)"ttl");
        boolean $i$f$Redis = false;
        boolean $i$f$AutoRedisCodec = false;
        Intrinsics.needClassReification();
        return RedisStorageKt.Redis($this$Redis, uri, (RedisCodec)new RedisCodec<String, T>(autoMarshalling){
            final /* synthetic */ AutoMarshalling $autoMarshalling;
            {
                this.$autoMarshalling = $autoMarshalling;
            }

            public String decodeKey(ByteBuffer bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                String string = StandardCharsets.UTF_8.decode(bytes).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }

            /*
             * WARNING - void declaration
             */
            public T decodeValue(ByteBuffer bytes) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                AutoMarshalling autoMarshalling = this.$autoMarshalling;
                String string = StandardCharsets.UTF_8.decode(bytes).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String input$iv = string;
                boolean $i$f$stringAsA = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return (T)this_$iv.asA(input$iv, Reflection.getOrCreateKotlinClass(Object.class));
            }

            public ByteBuffer encodeKey(String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return new StringCodec().encodeKey(key);
            }

            public ByteBuffer encodeValue(T value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                return StandardCharsets.UTF_8.encode(this.$autoMarshalling.asFormatString(value));
            }
        }, ttl);
    }

    public static /* synthetic */ Storage Redis$default(Storage.Companion $this$Redis_u24default, Uri uri, AutoMarshalling autoMarshalling, Function1 ttl, int n, Object object) {
        if ((n & 2) != 0) {
            autoMarshalling = (AutoMarshalling)Moshi.INSTANCE;
        }
        if ((n & 4) != 0) {
            Intrinsics.needClassReification();
            ttl = Redis.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)$this$Redis_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)autoMarshalling, (String)"autoMarshalling");
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        boolean $i$f$Redis = false;
        boolean $i$f$AutoRedisCodec = false;
        Intrinsics.needClassReification();
        return RedisStorageKt.Redis($this$Redis_u24default, uri, (RedisCodec)new /* invalid duplicate definition of identical inner class */, ttl);
    }

    @NotNull
    public static final <T> Storage<T> Redis(@NotNull Storage.Companion $this$Redis, @NotNull Uri uri, @NotNull RedisCodec<String, T> codec, @NotNull Function1<? super T, Duration> ttl) {
        Intrinsics.checkNotNullParameter((Object)$this$Redis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        Intrinsics.checkNotNullParameter(ttl, (String)"ttl");
        RedisCommands redisCommands = RedisClient.create((RedisURI)RedisStorageKt.asRedis(uri)).connect(codec).sync();
        Intrinsics.checkNotNullExpressionValue((Object)redisCommands, (String)"sync(...)");
        return RedisStorageKt.RedisWithDynamicTtl($this$Redis, redisCommands, ttl);
    }

    public static /* synthetic */ Storage Redis$default(Storage.Companion companion, Uri uri, RedisCodec redisCodec, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = RedisStorageKt::Redis$lambda$0;
        }
        return RedisStorageKt.Redis(companion, uri, redisCodec, function1);
    }

    @NotNull
    public static final <T> Storage<T> Redis(@NotNull Storage.Companion $this$Redis, @NotNull RedisCommands<String, T> redis, @NotNull Duration ttl) {
        Intrinsics.checkNotNullParameter((Object)$this$Redis, (String)"<this>");
        Intrinsics.checkNotNullParameter(redis, (String)"redis");
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        return RedisStorageKt.RedisWithDynamicTtl($this$Redis, redis, arg_0 -> RedisStorageKt.Redis$lambda$1(ttl, arg_0));
    }

    public static /* synthetic */ Storage Redis$default(Storage.Companion companion, RedisCommands redisCommands, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            duration = Duration.ofHours(1L);
        }
        return RedisStorageKt.Redis(companion, redisCommands, duration);
    }

    @NotNull
    public static final <T> Storage<T> RedisWithDynamicTtl(@NotNull Storage.Companion $this$RedisWithDynamicTtl, @NotNull RedisCommands<String, T> redis, @NotNull Function1<? super T, Duration> ttl) {
        Intrinsics.checkNotNullParameter((Object)$this$RedisWithDynamicTtl, (String)"<this>");
        Intrinsics.checkNotNullParameter(redis, (String)"redis");
        Intrinsics.checkNotNullParameter(ttl, (String)"ttl");
        return new Storage<T>(redis, ttl){
            final /* synthetic */ RedisCommands<String, T> $redis;
            final /* synthetic */ Function1<T, Duration> $ttl;
            {
                this.$redis = $redis;
                this.$ttl = $ttl;
            }

            public T get(String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return (T)this.$redis.get((Object)key);
            }

            public void set(String key, T data) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                String result = this.$redis.set((Object)key, data, SetArgs.Builder.ex((long)((Duration)this.$ttl.invoke(data)).toSeconds()));
                if (!Intrinsics.areEqual((Object)result, (Object)"OK")) {
                    throw new RuntimeException(result);
                }
            }

            public boolean remove(String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Object[] objectArray = new String[]{key};
                return this.$redis.del(objectArray) >= 1L;
            }

            public boolean removeAll(String keyPrefix) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
                List keys = this.$redis.keys((Object)(keyPrefix + "*"));
                if (keys.isEmpty()) {
                    bl = false;
                } else {
                    Intrinsics.checkNotNull((Object)keys);
                    Collection $this$toTypedArray$iv = keys;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    this.$redis.del((Object[])Arrays.copyOf(stringArray, stringArray.length));
                    bl = true;
                }
                return bl;
            }

            public Set<String> keySet(String keyPrefix) {
                Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
                List list = this.$redis.keys((Object)(keyPrefix + "*"));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"keys(...)");
                return CollectionsKt.toSet((Iterable)list);
            }

            public void minusAssign(String key) {
                Storage.DefaultImpls.minusAssign((Storage)this, (String)key);
            }
        };
    }

    public static /* synthetic */ Storage RedisWithDynamicTtl$default(Storage.Companion companion, RedisCommands redisCommands, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = RedisStorageKt::RedisWithDynamicTtl$lambda$2;
        }
        return RedisStorageKt.RedisWithDynamicTtl(companion, redisCommands, function1);
    }

    public static final RedisURI asRedis(@NotNull Uri $this$asRedis) {
        Intrinsics.checkNotNullParameter((Object)$this$asRedis, (String)"<this>");
        return RedisURI.create((URI)new URI($this$asRedis.toString()));
    }

    private static final Duration Redis$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Duration.ofHours(1L);
    }

    private static final Duration Redis$lambda$1(Duration $ttl, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $ttl;
    }

    private static final Duration RedisWithDynamicTtl$lambda$2(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Duration.ofHours(1L);
    }
}

