/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.format;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Body;
import org.http4k.format.Json;
import org.http4k.format.JsonType;
import org.http4k.lens.BiDiBodyLensSpec;
import org.http4k.lens.BiDiLensSpec;
import org.http4k.lens.ContentNegotiation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\"\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000e0\u000b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0002H\u0016J\f\u0010\u0014\u001a\u00020\u000f*\u00020\u0002H\u0016J!\u0010\u0015\u001a\u00020\u0002\"\u000e\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u00020\u00020\u000b*\u0002H\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J-\u0010\u0018\u001a\u00020\u0002\"\u001a\b\u0000\u0010\u0019*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000e0\u000b*\u0002H\u0019H\u0016\u00a2\u0006\u0002\u0010\u0017J\f\u0010\u0018\u001a\u00020\u0002*\u00020\u000fH\u0016J\u000e\u0010\u001a\u001a\u00020\u0002*\u0004\u0018\u00010\u001bH\u0016J\u000e\u0010\u001a\u001a\u00020\u0002*\u0004\u0018\u00010\u001cH\u0016J\u0013\u0010\u001a\u001a\u00020\u0002*\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001a\u001a\u00020\u0002*\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u0013\u0010\u001a\u001a\u00020\u0002*\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010\"J\u0013\u0010\u001a\u001a\u00020\u0002*\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010$J\u000e\u0010\u001a\u001a\u00020\u0002*\u0004\u0018\u00010\u000fH\u0016J\f\u0010%\u001a\u00020\u000f*\u00020\u0002H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/http4k/format/ConfigurableGson;", "Lorg/http4k/format/Json;", "Lcom/google/gson/JsonElement;", "builder", "Lcom/google/gson/GsonBuilder;", "(Lcom/google/gson/GsonBuilder;)V", "compact", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "pretty", "elements", "", "value", "fields", "Lkotlin/Pair;", "", "node", "text", "typeOf", "Lorg/http4k/format/JsonType;", "asCompactJsonString", "asJsonArray", "T", "(Ljava/lang/Iterable;)Lcom/google/gson/JsonElement;", "asJsonObject", "LIST", "asJsonValue", "Ljava/math/BigDecimal;", "Ljava/math/BigInteger;", "", "(Ljava/lang/Boolean;)Lcom/google/gson/JsonElement;", "", "(Ljava/lang/Double;)Lcom/google/gson/JsonElement;", "", "(Ljava/lang/Integer;)Lcom/google/gson/JsonElement;", "", "(Ljava/lang/Long;)Lcom/google/gson/JsonElement;", "asPrettyJsonString", "http4k-format-gson_main"})
public class ConfigurableGson
implements Json<JsonElement, JsonElement> {
    private final Gson compact;
    private final Gson pretty;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public JsonType typeOf(@NotNull JsonElement value) {
        JsonType jsonType;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (value.isJsonArray()) {
            jsonType = JsonType.Array;
            return jsonType;
        } else if (value.isJsonNull()) {
            jsonType = JsonType.Null;
            return jsonType;
        } else if (value.isJsonObject()) {
            jsonType = JsonType.Object;
            return jsonType;
        } else {
            if (!value.isJsonPrimitive()) throw (Throwable)new IllegalArgumentException("Don't know now to translate " + value);
            JsonPrimitive prim = value.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                jsonType = JsonType.Boolean;
                return jsonType;
            } else if (prim.isNumber()) {
                jsonType = JsonType.Number;
                return jsonType;
            } else {
                if (!prim.isString()) throw (Throwable)new IllegalArgumentException("Don't know now to translate " + value);
                jsonType = JsonType.String;
            }
        }
        return jsonType;
    }

    @NotNull
    public JsonElement asJsonObject(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        JsonObject jsonObject = new JsonParser().parse($receiver).getAsJsonObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"JsonParser().parse(this).asJsonObject");
        return (JsonElement)jsonObject;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable String $receiver) {
        JsonElement jsonElement;
        String string = $receiver;
        if (string != null) {
            String string2;
            String it = string2 = string;
            jsonElement = (JsonElement)new JsonPrimitive($receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable Integer $receiver) {
        JsonElement jsonElement;
        Integer n = $receiver;
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            jsonElement = (JsonElement)new JsonPrimitive((Number)$receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable Double $receiver) {
        JsonElement jsonElement;
        Double d = $receiver;
        if (d != null) {
            Double d2 = d;
            double it = ((Number)d2).doubleValue();
            jsonElement = (JsonElement)new JsonPrimitive((Number)new BigDecimal($receiver));
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable Long $receiver) {
        JsonElement jsonElement;
        Long l = $receiver;
        if (l != null) {
            Long l2 = l;
            long it = ((Number)l2).longValue();
            jsonElement = (JsonElement)new JsonPrimitive((Number)$receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable BigDecimal $receiver) {
        JsonElement jsonElement;
        BigDecimal bigDecimal = $receiver;
        if (bigDecimal != null) {
            BigDecimal bigDecimal2;
            BigDecimal it = bigDecimal2 = bigDecimal;
            jsonElement = (JsonElement)new JsonPrimitive((Number)$receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable BigInteger $receiver) {
        JsonElement jsonElement;
        BigInteger bigInteger = $receiver;
        if (bigInteger != null) {
            BigInteger bigInteger2;
            BigInteger it = bigInteger2 = bigInteger;
            jsonElement = (JsonElement)new JsonPrimitive((Number)$receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable Boolean $receiver) {
        JsonElement jsonElement;
        Boolean bl = $receiver;
        if (bl != null) {
            Boolean bl2 = bl;
            boolean it = bl2;
            jsonElement = (JsonElement)new JsonPrimitive($receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Iterable<? extends JsonElement>> JsonElement asJsonArray(@NotNull T $receiver) {
        void $receiver$iv;
        JsonArray initial$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        T t = $receiver;
        JsonArray accumulator$iv = initial$iv = new JsonArray();
        for (Object element$iv : $receiver$iv) {
            void o;
            JsonElement jsonElement = (JsonElement)element$iv;
            JsonArray memo = accumulator$iv;
            memo.add((JsonElement)o);
            accumulator$iv = memo;
        }
        return (JsonElement)accumulator$iv;
    }

    @NotNull
    public String asPrettyJsonString(@NotNull JsonElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = this.pretty.toJson($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pretty.toJson(this)");
        return string;
    }

    @NotNull
    public String asCompactJsonString(@NotNull JsonElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = this.compact.toJson($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"compact.toJson(this)");
        return string;
    }

    @NotNull
    public <LIST extends Iterable<? extends Pair<? extends String, ? extends JsonElement>>> JsonElement asJsonObject(@NotNull LIST $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        JsonObject root = new JsonObject();
        LIST $receiver$iv = $receiver;
        Iterator<? extends Pair<? extends String, ? extends JsonElement>> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Pair<? extends String, ? extends JsonElement> element$iv;
            Pair<? extends String, ? extends JsonElement> it = element$iv = iterator.next();
            root.add((String)it.getFirst(), (JsonElement)it.getSecond());
        }
        return (JsonElement)root;
    }

    @NotNull
    public Iterable<Pair<String, JsonElement>> fields(@NotNull JsonElement node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        List fieldList = new ArrayList();
        for (Map.Entry entry : node.getAsJsonObject().entrySet()) {
            Object object = entry;
            String key = (String)object.getKey();
            object = entry;
            JsonElement value = (JsonElement)object.getValue();
            object = fieldList;
            Pair pair = TuplesKt.to((Object)key, (Object)value);
            object.add(pair);
        }
        return fieldList;
    }

    @NotNull
    public Iterable<JsonElement> elements(@NotNull JsonElement value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        JsonArray jsonArray = value.getAsJsonArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"value.asJsonArray");
        return (Iterable)jsonArray;
    }

    @NotNull
    public String text(@NotNull JsonElement value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value.getAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.asString");
        return string;
    }

    public ConfigurableGson(@NotNull GsonBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.compact = builder.create();
        this.pretty = builder.setPrettyPrinting().create();
    }

    @NotNull
    public <T extends JsonElement> JsonElement array(@NotNull Iterable<? extends T> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return (JsonElement)Json.DefaultImpls.array((Json)this, value);
    }

    @NotNull
    public JsonElement number(@NotNull BigInteger value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return (JsonElement)Json.DefaultImpls.number((Json)this, (BigInteger)value);
    }

    @NotNull
    public JsonElement number(@NotNull BigDecimal value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return (JsonElement)Json.DefaultImpls.number((Json)this, (BigDecimal)value);
    }

    @NotNull
    public JsonElement number(double value) {
        return (JsonElement)Json.DefaultImpls.number((Json)this, (double)value);
    }

    @NotNull
    public JsonElement number(long value) {
        return (JsonElement)Json.DefaultImpls.number((Json)this, (long)value);
    }

    @NotNull
    public JsonElement number(int value) {
        return (JsonElement)Json.DefaultImpls.number((Json)this, (int)value);
    }

    @NotNull
    public BiDiBodyLensSpec<JsonElement> body(@Nullable String description, @NotNull ContentNegotiation contentNegotiation) {
        Intrinsics.checkParameterIsNotNull((Object)contentNegotiation, (String)"contentNegotiation");
        return Json.DefaultImpls.body((Json)this, (String)description, (ContentNegotiation)contentNegotiation);
    }

    @NotNull
    public String pretty(@NotNull JsonElement node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return Json.DefaultImpls.pretty((Json)this, (Object)node);
    }

    @NotNull
    public String compact(@NotNull JsonElement node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return Json.DefaultImpls.compact((Json)this, (Object)node);
    }

    @NotNull
    public <IN> BiDiLensSpec<IN, String, JsonElement> lens(@NotNull BiDiLensSpec<IN, String, String> spec) {
        Intrinsics.checkParameterIsNotNull(spec, (String)"spec");
        return Json.DefaultImpls.lens((Json)this, spec);
    }

    @NotNull
    public JsonElement string(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return (JsonElement)Json.DefaultImpls.string((Json)this, (String)value);
    }

    @NotNull
    public JsonElement boolean(boolean value) {
        return (JsonElement)Json.DefaultImpls.boolean((Json)this, (boolean)value);
    }

    @NotNull
    public JsonElement parse(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        return (JsonElement)Json.DefaultImpls.parse((Json)this, (String)s);
    }

    @NotNull
    public JsonElement nullNode() {
        return (JsonElement)Json.DefaultImpls.nullNode((Json)this);
    }

    @NotNull
    public JsonElement obj() {
        return (JsonElement)Json.DefaultImpls.obj((Json)this);
    }

    @NotNull
    public <T extends JsonElement> JsonElement obj(@NotNull Iterable<? extends Pair<String, ? extends T>> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return (JsonElement)Json.DefaultImpls.obj((Json)this, value);
    }

    @NotNull
    public <T extends JsonElement> JsonElement obj(Pair<String, ? extends T> ... fields) {
        Intrinsics.checkParameterIsNotNull(fields, (String)"fields");
        return (JsonElement)Json.DefaultImpls.obj((Json)this, fields);
    }

    @NotNull
    public <IN> BiDiLensSpec<IN, String, JsonElement> json(@NotNull BiDiLensSpec<IN, String, String> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Json.DefaultImpls.json((Json)this, $receiver);
    }

    @NotNull
    public BiDiBodyLensSpec<JsonElement> json(@NotNull Body.Companion $receiver, @Nullable String description, @NotNull ContentNegotiation contentNegotiation) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)contentNegotiation, (String)"contentNegotiation");
        return Json.DefaultImpls.json((Json)this, (Body.Companion)$receiver, (String)description, (ContentNegotiation)contentNegotiation);
    }
}

