/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.format;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.http4k.format.InvalidJsonException;
import org.http4k.format.JsonLibAutoMarshallingJson;
import org.http4k.format.JsonType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J-\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J-\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\"\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J \u0010\u001e\u001a\n \b*\u0004\u0018\u00010\u00120\u00122\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\f\u0010\"\u001a\u00020\u0012*\u00020\u0002H\u0016J!\u0010#\u001a\u00020\u0002\"\u000e\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u00020\u00020\u0019*\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010$J-\u0010\u0014\u001a\u00020\u0002\"\u001a\b\u0000\u0010%*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00020\u001b0\u0019*\u0002H%H\u0016\u00a2\u0006\u0002\u0010$J\f\u0010\u0014\u001a\u00020\u0002*\u00020\u0012H\u0016J\u000e\u0010&\u001a\u00020\u0002*\u0004\u0018\u00010'H\u0016J\u000e\u0010&\u001a\u00020\u0002*\u0004\u0018\u00010(H\u0016J\u0013\u0010&\u001a\u00020\u0002*\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010)J\u0013\u0010&\u001a\u00020\u0002*\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0002\u0010+J\u0013\u0010&\u001a\u00020\u0002*\u0004\u0018\u00010,H\u0016\u00a2\u0006\u0002\u0010-J\u0013\u0010&\u001a\u00020\u0002*\u0004\u0018\u00010.H\u0016\u00a2\u0006\u0002\u0010/J\u000e\u0010&\u001a\u00020\u0002*\u0004\u0018\u00010\u0012H\u0016J\f\u00100\u001a\u00020\u0012*\u00020\u0002H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/http4k/format/ConfigurableGson;", "Lorg/http4k/format/JsonLibAutoMarshallingJson;", "Lcom/google/gson/JsonElement;", "builder", "Lcom/google/gson/GsonBuilder;", "(Lcom/google/gson/GsonBuilder;)V", "compact", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "pretty", "asA", "T", "", "j", "target", "Lkotlin/reflect/KClass;", "(Lcom/google/gson/JsonElement;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "input", "", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "asJsonObject", "bool", "", "value", "elements", "", "fields", "Lkotlin/Pair;", "node", "text", "textValueOf", "name", "typeOf", "Lorg/http4k/format/JsonType;", "asCompactJsonString", "asJsonArray", "(Ljava/lang/Iterable;)Lcom/google/gson/JsonElement;", "LIST", "asJsonValue", "Ljava/math/BigDecimal;", "Ljava/math/BigInteger;", "(Ljava/lang/Boolean;)Lcom/google/gson/JsonElement;", "", "(Ljava/lang/Double;)Lcom/google/gson/JsonElement;", "", "(Ljava/lang/Integer;)Lcom/google/gson/JsonElement;", "", "(Ljava/lang/Long;)Lcom/google/gson/JsonElement;", "asPrettyJsonString", "http4k-format-gson"})
public class ConfigurableGson
extends JsonLibAutoMarshallingJson<JsonElement> {
    private final Gson compact;
    private final Gson pretty;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public JsonType typeOf(@NotNull JsonElement value) {
        JsonType jsonType;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (value.isJsonArray()) {
            jsonType = JsonType.Array;
            return jsonType;
        } else if (value.isJsonNull()) {
            jsonType = JsonType.Null;
            return jsonType;
        } else if (value.isJsonObject()) {
            jsonType = JsonType.Object;
            return jsonType;
        } else {
            JsonPrimitive prim;
            if (!value.isJsonPrimitive()) throw (Throwable)new IllegalArgumentException("Don't know now to translate " + value);
            JsonPrimitive jsonPrimitive = prim = value.getAsJsonPrimitive();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"prim");
            if (jsonPrimitive.isBoolean()) {
                jsonType = JsonType.Boolean;
                return jsonType;
            } else if (prim.isNumber()) {
                jsonType = JsonType.Number;
                return jsonType;
            } else {
                if (!prim.isString()) throw (Throwable)new IllegalArgumentException("Don't know now to translate " + value);
                jsonType = JsonType.String;
            }
        }
        return jsonType;
    }

    @NotNull
    public JsonElement asJsonObject(@NotNull String $receiver) {
        JsonElement jsonElement;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        JsonElement it = jsonElement = new JsonParser().parse($receiver);
        boolean bl = false;
        JsonElement jsonElement2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"it");
        if (!jsonElement2.isJsonArray() && !it.isJsonObject()) {
            throw (Throwable)new InvalidJsonException("Could not convert to a JSON Object or Array. " + $receiver, null, 2, null);
        }
        return it;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable String $receiver) {
        JsonElement jsonElement;
        String string = $receiver;
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            jsonElement = (JsonElement)new JsonPrimitive($receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable Integer $receiver) {
        JsonElement jsonElement;
        Integer n = $receiver;
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            jsonElement = (JsonElement)new JsonPrimitive((Number)$receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable Double $receiver) {
        JsonElement jsonElement;
        Double d = $receiver;
        if (d != null) {
            Double d2 = d;
            double it = ((Number)d2).doubleValue();
            boolean bl = false;
            jsonElement = (JsonElement)new JsonPrimitive((Number)$receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable Long $receiver) {
        JsonElement jsonElement;
        Long l = $receiver;
        if (l != null) {
            Long l2 = l;
            long it = ((Number)l2).longValue();
            boolean bl = false;
            jsonElement = (JsonElement)new JsonPrimitive((Number)$receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable BigDecimal $receiver) {
        JsonElement jsonElement;
        BigDecimal bigDecimal2 = $receiver;
        if (bigDecimal2 != null) {
            BigDecimal bigDecimal3;
            BigDecimal it = bigDecimal3 = bigDecimal2;
            boolean bl = false;
            jsonElement = (JsonElement)new JsonPrimitive((Number)$receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable BigInteger $receiver) {
        JsonElement jsonElement;
        BigInteger bigInteger2 = $receiver;
        if (bigInteger2 != null) {
            BigInteger bigInteger3;
            BigInteger it = bigInteger3 = bigInteger2;
            boolean bl = false;
            jsonElement = (JsonElement)new JsonPrimitive((Number)$receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @NotNull
    public JsonElement asJsonValue(@Nullable Boolean $receiver) {
        JsonElement jsonElement;
        Boolean bl = $receiver;
        if (bl != null) {
            Boolean bl2 = bl;
            boolean it = bl2;
            boolean bl3 = false;
            jsonElement = (JsonElement)new JsonPrimitive($receiver);
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Iterable<? extends JsonElement>> JsonElement asJsonArray(@NotNull T $receiver) {
        void $receiver$iv;
        JsonArray initial$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        T t = $receiver;
        JsonArray accumulator$iv = initial$iv = new JsonArray();
        for (Object element$iv : $receiver$iv) {
            void o;
            JsonElement jsonElement = (JsonElement)element$iv;
            JsonArray memo = accumulator$iv;
            boolean bl = false;
            memo.add((JsonElement)o);
            accumulator$iv = memo;
        }
        return (JsonElement)accumulator$iv;
    }

    @NotNull
    public String asPrettyJsonString(@NotNull JsonElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = this.pretty.toJson($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pretty.toJson(this)");
        return string;
    }

    @NotNull
    public String asCompactJsonString(@NotNull JsonElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = this.compact.toJson($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"compact.toJson(this)");
        return string;
    }

    @NotNull
    public <LIST extends Iterable<? extends Pair<? extends String, ? extends JsonElement>>> JsonElement asJsonObject(@NotNull LIST $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        JsonObject root = new JsonObject();
        LIST $receiver$iv = $receiver;
        Iterator<? extends Pair<? extends String, ? extends JsonElement>> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Pair<? extends String, ? extends JsonElement> element$iv;
            Pair<? extends String, ? extends JsonElement> it = element$iv = iterator.next();
            boolean bl = false;
            root.add((String)it.getFirst(), (JsonElement)it.getSecond());
        }
        return (JsonElement)root;
    }

    @NotNull
    public Iterable<Pair<String, JsonElement>> fields(@NotNull JsonElement node) {
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (this.typeOf(node) != JsonType.Object) {
            iterable = CollectionsKt.emptyList();
        } else {
            List fieldList = new ArrayList();
            for (Map.Entry entry : node.getAsJsonObject().entrySet()) {
                Object object = entry;
                String key = (String)object.getKey();
                object = entry;
                JsonElement value = (JsonElement)object.getValue();
                object = fieldList;
                Pair pair = TuplesKt.to((Object)key, (Object)value);
                object.add(pair);
            }
            iterable = fieldList;
        }
        return iterable;
    }

    @NotNull
    public Iterable<JsonElement> elements(@NotNull JsonElement value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        JsonArray jsonArray = value.getAsJsonArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"value.asJsonArray");
        return (Iterable)jsonArray;
    }

    @NotNull
    public String text(@NotNull JsonElement value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value.getAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.asString");
        return string;
    }

    public boolean bool(@NotNull JsonElement value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return value.getAsBoolean();
    }

    @NotNull
    public JsonElement asJsonObject(@NotNull Object input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        JsonElement jsonElement = this.compact.toJsonTree(input);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"compact.toJsonTree(input)");
        return jsonElement;
    }

    @NotNull
    public <T> T asA(@NotNull String input, @NotNull KClass<T> target) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Object object = this.compact.fromJson(input, JvmClassMappingKt.getJavaClass(target));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"compact.fromJson(input, target.java)");
        return (T)object;
    }

    @NotNull
    public <T> T asA(@NotNull JsonElement j, @NotNull KClass<T> target) {
        Intrinsics.checkParameterIsNotNull((Object)j, (String)"j");
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Object object = this.compact.fromJson(j, JvmClassMappingKt.getJavaClass(target));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"compact.fromJson(j, target.java)");
        return (T)object;
    }

    public String textValueOf(@NotNull JsonElement node, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        JsonElement jsonElement = node;
        if (!(jsonElement instanceof JsonObject)) {
            throw (Throwable)new IllegalArgumentException("node is not an object");
        }
        JsonElement jsonElement2 = ((JsonObject)node).get(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"node[name]");
        return jsonElement2.getAsString();
    }

    public ConfigurableGson(@NotNull GsonBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.compact = builder.create();
        this.pretty = builder.setPrettyPrinting().create();
    }
}

