/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.http4k.core.Body;
import org.http4k.format.AutoMarshallingJson;
import org.http4k.format.JsonType;
import org.http4k.lens.BiDiBodyLensSpec;
import org.http4k.lens.ContentNegotiation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J-\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ-\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\"\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00020\u00160\u00132\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u001e\u0010\u0006\u001a\u0002H\u0007\"\n\b\u0000\u0010\u0007\u0018\u0001*\u00020\b*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u0006\u001a\u0002H\u0007\"\n\b\u0000\u0010\u0007\u0018\u0001*\u00020\b*\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u001cJ\f\u0010\u001d\u001a\u00020\u000e*\u00020\u0002H\u0016J!\u0010\u001e\u001a\u00020\u0002\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u00020\u00020\u0013*\u0002H\u0007H\u0016\u00a2\u0006\u0002\u0010\u001fJ-\u0010\u0010\u001a\u00020\u0002\"\u001a\b\u0000\u0010 *\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00020\u00160\u0013*\u0002H H\u0016\u00a2\u0006\u0002\u0010\u001fJ\f\u0010\u0010\u001a\u00020\u0002*\u00020\u000eH\u0016J\u000e\u0010!\u001a\u00020\u0002*\u0004\u0018\u00010\"H\u0016J\u000e\u0010!\u001a\u00020\u0002*\u0004\u0018\u00010#H\u0016J\u0013\u0010!\u001a\u00020\u0002*\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%J\u0013\u0010!\u001a\u00020\u0002*\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010'J\u0013\u0010!\u001a\u00020\u0002*\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010)J\u0013\u0010!\u001a\u00020\u0002*\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0002\u0010+J\u000e\u0010!\u001a\u00020\u0002*\u0004\u0018\u00010\u000eH\u0016J\f\u0010,\u001a\u00020\u000e*\u00020\u0002H\u0016J5\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u00070.\"\n\b\u0000\u0010\u0007\u0018\u0001*\u00020\b*\u00020/2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u00101\u001a\u000202H\u0086\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/http4k/format/ConfigurableJackson;", "Lorg/http4k/format/AutoMarshallingJson;", "Lcom/fasterxml/jackson/databind/JsonNode;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "asA", "T", "", "j", "c", "Lkotlin/reflect/KClass;", "(Lcom/fasterxml/jackson/databind/JsonNode;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "s", "", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "asJsonObject", "a", "elements", "", "value", "fields", "Lkotlin/Pair;", "node", "text", "typeOf", "Lorg/http4k/format/JsonType;", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/Object;", "(Ljava/lang/String;)Ljava/lang/Object;", "asCompactJsonString", "asJsonArray", "(Ljava/lang/Iterable;)Lcom/fasterxml/jackson/databind/JsonNode;", "LIST", "asJsonValue", "Ljava/math/BigDecimal;", "Ljava/math/BigInteger;", "", "(Ljava/lang/Boolean;)Lcom/fasterxml/jackson/databind/JsonNode;", "", "(Ljava/lang/Double;)Lcom/fasterxml/jackson/databind/JsonNode;", "", "(Ljava/lang/Integer;)Lcom/fasterxml/jackson/databind/JsonNode;", "", "(Ljava/lang/Long;)Lcom/fasterxml/jackson/databind/JsonNode;", "asPrettyJsonString", "auto", "Lorg/http4k/lens/BiDiBodyLensSpec;", "Lorg/http4k/core/Body$Companion;", "description", "contentNegotiation", "Lorg/http4k/lens/ContentNegotiation;", "http4k-format-jackson"})
public class ConfigurableJackson
extends AutoMarshallingJson<JsonNode> {
    private final ObjectMapper mapper;

    @NotNull
    public JsonType typeOf(@NotNull JsonNode value) {
        JsonType jsonType;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        JsonNode jsonNode = value;
        if (jsonNode instanceof TextNode) {
            jsonType = JsonType.String;
        } else if (jsonNode instanceof BooleanNode) {
            jsonType = JsonType.Boolean;
        } else if (jsonNode instanceof NumericNode) {
            jsonType = JsonType.Number;
        } else if (jsonNode instanceof ArrayNode) {
            jsonType = JsonType.Array;
        } else if (jsonNode instanceof ObjectNode) {
            jsonType = JsonType.Object;
        } else if (jsonNode instanceof NullNode) {
            jsonType = JsonType.Null;
        } else {
            throw (Throwable)new IllegalArgumentException("Don't know now to translate " + value);
        }
        return jsonType;
    }

    @NotNull
    public JsonNode asJsonObject(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = this.mapper.readValue($receiver, JsonNode.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"mapper.readValue(this, JsonNode::class.java)");
        return (JsonNode)object;
    }

    @NotNull
    public JsonNode asJsonValue(@Nullable String $receiver) {
        JsonNode jsonNode;
        String string = $receiver;
        if (string != null) {
            String string2;
            String it = string2 = string;
            jsonNode = (JsonNode)new TextNode($receiver);
        } else {
            NullNode nullNode = NullNode.instance;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullNode, (String)"NullNode.instance");
            jsonNode = (JsonNode)nullNode;
        }
        return jsonNode;
    }

    @NotNull
    public JsonNode asJsonValue(@Nullable Integer $receiver) {
        JsonNode jsonNode;
        Integer n = $receiver;
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            jsonNode = (JsonNode)new IntNode($receiver.intValue());
        } else {
            NullNode nullNode = NullNode.instance;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullNode, (String)"NullNode.instance");
            jsonNode = (JsonNode)nullNode;
        }
        return jsonNode;
    }

    @NotNull
    public JsonNode asJsonValue(@Nullable Double $receiver) {
        JsonNode jsonNode;
        Double d = $receiver;
        if (d != null) {
            Double d2 = d;
            double it = ((Number)d2).doubleValue();
            jsonNode = (JsonNode)new DecimalNode(new BigDecimal($receiver));
        } else {
            NullNode nullNode = NullNode.instance;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullNode, (String)"NullNode.instance");
            jsonNode = (JsonNode)nullNode;
        }
        return jsonNode;
    }

    @NotNull
    public JsonNode asJsonValue(@Nullable Long $receiver) {
        JsonNode jsonNode;
        Long l = $receiver;
        if (l != null) {
            Long l2 = l;
            long it = ((Number)l2).longValue();
            jsonNode = (JsonNode)new LongNode($receiver.longValue());
        } else {
            NullNode nullNode = NullNode.instance;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullNode, (String)"NullNode.instance");
            jsonNode = (JsonNode)nullNode;
        }
        return jsonNode;
    }

    @NotNull
    public JsonNode asJsonValue(@Nullable BigDecimal $receiver) {
        JsonNode jsonNode;
        BigDecimal bigDecimal = $receiver;
        if (bigDecimal != null) {
            BigDecimal bigDecimal2;
            BigDecimal it = bigDecimal2 = bigDecimal;
            jsonNode = (JsonNode)new DecimalNode($receiver);
        } else {
            NullNode nullNode = NullNode.instance;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullNode, (String)"NullNode.instance");
            jsonNode = (JsonNode)nullNode;
        }
        return jsonNode;
    }

    @NotNull
    public JsonNode asJsonValue(@Nullable BigInteger $receiver) {
        JsonNode jsonNode;
        BigInteger bigInteger = $receiver;
        if (bigInteger != null) {
            BigInteger bigInteger2;
            BigInteger it = bigInteger2 = bigInteger;
            jsonNode = (JsonNode)new BigIntegerNode($receiver);
        } else {
            NullNode nullNode = NullNode.instance;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullNode, (String)"NullNode.instance");
            jsonNode = (JsonNode)nullNode;
        }
        return jsonNode;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JsonNode asJsonValue(@Nullable Boolean $receiver) {
        JsonNode jsonNode;
        Boolean bl = $receiver;
        if (bl != null) {
            Boolean bl2 = bl;
            boolean it = bl2;
            bl = BooleanNode.valueOf((boolean)$receiver);
            if (bl != null) {
                jsonNode = (JsonNode)bl;
                return jsonNode;
            }
        }
        NullNode nullNode = NullNode.instance;
        Intrinsics.checkExpressionValueIsNotNull((Object)nullNode, (String)"NullNode.instance");
        jsonNode = (JsonNode)nullNode;
        return jsonNode;
    }

    @NotNull
    public <T extends Iterable<? extends JsonNode>> JsonNode asJsonArray(@NotNull T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        ArrayNode root = this.mapper.createArrayNode();
        root.addAll((Collection)CollectionsKt.toList($receiver));
        ArrayNode arrayNode = root;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayNode, (String)"root");
        return (JsonNode)arrayNode;
    }

    @NotNull
    public String asPrettyJsonString(@NotNull JsonNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mapper.writerWithDefault\u2026.writeValueAsString(this)");
        return string;
    }

    @NotNull
    public String asCompactJsonString(@NotNull JsonNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = this.mapper.writeValueAsString((Object)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mapper.writeValueAsString(this)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <LIST extends Iterable<? extends Pair<? extends String, ? extends JsonNode>>> JsonNode asJsonObject(@NotNull LIST $receiver) {
        Pair[] pairArray;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        ObjectNode root = this.mapper.createObjectNode();
        Collection collection = CollectionsKt.toList($receiver);
        ObjectNode objectNode = root;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v0;
        Pair[] pairArray2 = thisCollection$iv.toArray(new Pair[thisCollection$iv.size()]);
        if (pairArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Pair[] pairArray3 = pairArray = pairArray2;
        objectNode.setAll(MapsKt.mapOf((Pair[])Arrays.copyOf(pairArray3, pairArray3.length)));
        ObjectNode objectNode2 = root;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectNode2, (String)"root");
        return (JsonNode)objectNode2;
    }

    @NotNull
    public Iterable<Pair<String, JsonNode>> fields(@NotNull JsonNode node) {
        Iterator iterator;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        List fieldList = new ArrayList();
        Iterator iterator2 = iterator = node.fields();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            Object object = entry;
            String key = (String)object.getKey();
            object = entry;
            JsonNode value = (JsonNode)object.getValue();
            object = fieldList;
            Pair pair = TuplesKt.to((Object)key, (Object)value);
            object.add(pair);
        }
        return fieldList;
    }

    @NotNull
    public Iterable<JsonNode> elements(@NotNull JsonNode value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return SequencesKt.asIterable((Sequence)SequencesKt.asSequence((Iterator)value.elements()));
    }

    @NotNull
    public String text(@NotNull JsonNode value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value.asText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.asText()");
        return string;
    }

    @NotNull
    public JsonNode asJsonObject(@NotNull Object a) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Object object = this.mapper.convertValue(a, JsonNode.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"mapper.convertValue(a, JsonNode::class.java)");
        return (JsonNode)object;
    }

    @NotNull
    public <T> T asA(@NotNull String s, @NotNull KClass<T> c) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        Object object = this.mapper.convertValue((Object)this.asJsonObject(s), JvmClassMappingKt.getJavaClass(c));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"mapper.convertValue(s.asJsonObject(), c.java)");
        return (T)object;
    }

    @NotNull
    public <T> T asA(@NotNull JsonNode j, @NotNull KClass<T> c) {
        Intrinsics.checkParameterIsNotNull((Object)j, (String)"j");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        Object object = this.mapper.convertValue((Object)j, JvmClassMappingKt.getJavaClass(c));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"mapper.convertValue(j, c.java)");
        return (T)object;
    }

    private final <T> T asA(@NotNull String $receiver) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.asA($receiver, Reflection.getOrCreateKotlinClass(Object.class));
    }

    private final <T> T asA(@NotNull JsonNode $receiver) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.asA($receiver, Reflection.getOrCreateKotlinClass(Object.class));
    }

    private final <T> BiDiBodyLensSpec<T> auto(@NotNull Body.Companion $receiver, String description, ContentNegotiation contentNegotiation) {
        BiDiBodyLensSpec biDiBodyLensSpec = this.json(Body.Companion, description, contentNegotiation);
        Intrinsics.needClassReification();
        return biDiBodyLensSpec.map(new Function1<JsonNode, T>(this){
            final /* synthetic */ ConfigurableJackson this$0;

            @NotNull
            public final T invoke(@NotNull JsonNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                JsonNode $receiver$iv = it;
                ConfigurableJackson this_$iv = this.this$0;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return this_$iv.asA($receiver$iv, Reflection.getOrCreateKotlinClass(Object.class));
            }
            {
                this.this$0 = configurableJackson;
                super(1);
            }
        }, new Function1<T, JsonNode>(this){
            final /* synthetic */ ConfigurableJackson this$0;

            @NotNull
            public final JsonNode invoke(@NotNull T it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return (JsonNode)this.this$0.anyAsJsonObject(it);
            }
            {
                this.this$0 = configurableJackson;
                super(1);
            }
        });
    }

    static /* bridge */ /* synthetic */ BiDiBodyLensSpec auto$default(ConfigurableJackson this_, Body.Companion $receiver, String description, ContentNegotiation contentNegotiation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: auto");
        }
        if ((n & 1) != 0) {
            description = null;
        }
        if ((n & 2) != 0) {
            contentNegotiation = ContentNegotiation.Companion.getNone();
        }
        BiDiBodyLensSpec biDiBodyLensSpec = this_.json(Body.Companion, description, contentNegotiation);
        Intrinsics.needClassReification();
        return biDiBodyLensSpec.map(new /* invalid duplicate definition of identical inner class */, new /* invalid duplicate definition of identical inner class */);
    }

    public ConfigurableJackson(@NotNull ObjectMapper mapper) {
        Intrinsics.checkParameterIsNotNull((Object)mapper, (String)"mapper");
        this.mapper = mapper;
    }
}

