/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.db.Transactor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tB%\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\fJ/\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0001\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000e0\u0007H\u0016\u00a2\u0006\u0002\u0010\u0012J3\u0010\u0013\u001a\u0002H\u000e\"\u0004\b\u0001\u0010\u000e*\u00020\u00052\u0006\u0010\u0014\u001a\u00028\u00002\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000e0\u0007H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0017*\u00060\u0018j\u0002`\u0019H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/http4k/db/DataSourceTransactor;", "Resource", "Lorg/http4k/db/Transactor;", "getConnection", "Lkotlin/Function0;", "Ljava/sql/Connection;", "createResource", "Lkotlin/Function1;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "dataSource", "Ljavax/sql/DataSource;", "(Ljavax/sql/DataSource;Lkotlin/jvm/functions/Function1;)V", "perform", "T", "mode", "Lorg/http4k/db/Transactor$Mode;", "work", "(Lorg/http4k/db/Transactor$Mode;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "runTransaction", "resource", "(Ljava/sql/Connection;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isSerialisationFailure", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "http4k-incubator-db"})
public final class DataSourceTransactor<Resource>
implements Transactor<Resource> {
    @NotNull
    private final Function0<Connection> getConnection;
    @NotNull
    private final Function1<Connection, Resource> createResource;

    public DataSourceTransactor(@NotNull Function0<? extends Connection> getConnection, @NotNull Function1<? super Connection, ? extends Resource> createResource) {
        Intrinsics.checkNotNullParameter(getConnection, (String)"getConnection");
        Intrinsics.checkNotNullParameter(createResource, (String)"createResource");
        this.getConnection = getConnection;
        this.createResource = createResource;
    }

    public DataSourceTransactor(@NotNull DataSource dataSource, @NotNull Function1<? super Connection, ? extends Resource> createResource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter(createResource, (String)"createResource");
        this((Function0<? extends Connection>)((Function0)new Function0<Connection>((Object)dataSource){

            public final Connection invoke() {
                return ((DataSource)this.receiver).getConnection();
            }
        }), createResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T perform(@NotNull Transactor.Mode mode, @NotNull Function1<? super Resource, ? extends T> work) {
        T t;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter(work, (String)"work");
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection.invoke();
        Throwable throwable = null;
        try {
            Connection c = (Connection)autoCloseable;
            boolean bl = false;
            c.setAutoCommit(false);
            c.setTransactionIsolation(8);
            c.setReadOnly(mode == Transactor.Mode.ReadOnly);
            t = this.runTransaction(c, this.createResource.invoke((Object)c), work);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return t;
    }

    private final <T> T runTransaction(Connection $this$runTransaction, Resource resource, Function1<? super Resource, ? extends T> work) {
        int tryCount = 0;
        while (true) {
            ++tryCount;
            try {
                Object result = work.invoke(resource);
                $this$runTransaction.commit();
                return (T)result;
            }
            catch (Exception e) {
                $this$runTransaction.rollback();
                if (tryCount != 3 && this.isSerialisationFailure(e)) continue;
                throw e;
            }
            break;
        }
    }

    private final boolean isSerialisationFailure(Exception $this$isSerialisationFailure) {
        SQLException sQLException = $this$isSerialisationFailure instanceof SQLException ? (SQLException)$this$isSerialisationFailure : null;
        return Intrinsics.areEqual((Object)(sQLException != null ? sQLException.getSQLState() : null), (Object)"40001");
    }
}

