/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.postbox.processing;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.ResultKt;
import dev.forkhandles.result4k.Success;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.db.Transactor;
import org.http4k.db.TransactorResultKt;
import org.http4k.events.Event;
import org.http4k.postbox.Postbox;
import org.http4k.postbox.PostboxError;
import org.http4k.postbox.processing.DefaultExecutionContext;
import org.http4k.postbox.processing.ExecutionContext;
import org.http4k.postbox.processing.ProcessingEvent;
import org.http4k.postbox.processing.RequestProcessingError;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B\u00f5\u0001\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u0012%\u0010\u0006\u001a!\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007j\u0002`\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\u0018\b\u0002\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0007j\u0002`\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u0012[\b\u0002\u0010\u0019\u001aU\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u001b\u00122\u00120\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0007j\u0011`\u001d\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u001c\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00120\u001aj\u0002`\u001e\u0012\u0014\b\u0002\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020 0\u0007\u00a2\u0006\u0004\b!\u0010\"J\u0006\u0010%\u001a\u00020\u0015J\u0006\u0010&\u001a\u00020\u0015J&\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020)0(2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020 0\u0007J8\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020)0(2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020 0\u0007H\u0002R\u0018\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0006\u001a!\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007j\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0007j\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000Ra\u0010\u0019\u001aU\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u001b\u00122\u00120\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0007j\u0011`\u001d\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u001c\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00120\u001aj\u0002`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020 0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/http4k/postbox/processing/PostboxProcessing;", "", "transactor", "Lorg/http4k/db/Transactor;", "Lorg/http4k/postbox/Postbox;", "Lorg/http4k/postbox/PostboxTransactor;", "target", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "batchSize", "", "maxFailures", "maxPollingTime", "Ljava/time/Duration;", "events", "Lorg/http4k/events/Event;", "", "Lorg/http4k/events/Events;", "context", "Lorg/http4k/postbox/processing/ExecutionContext;", "backoffStrategy", "Lkotlin/Function2;", "failures", "random", "Lorg/http4k/postbox/processing/RandomSource;", "Lorg/http4k/postbox/processing/BackoffStrategy;", "successCriteria", "", "<init>", "(Lorg/http4k/db/Transactor;Lkotlin/jvm/functions/Function1;IILjava/time/Duration;Lkotlin/jvm/functions/Function1;Lorg/http4k/postbox/processing/ExecutionContext;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "task", "Ljava/lang/Runnable;", "stop", "start", "processPendingRequests", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/postbox/processing/RequestProcessingError;", "processPendingRequest", "postbox", "pending", "Lorg/http4k/postbox/Postbox$PendingRequest;", "Companion", "http4k-incubator-db"})
@SourceDebugExtension(value={"SMAP\nProcessing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Processing.kt\norg/http4k/postbox/processing/PostboxProcessing\n+ 2 result.kt\ndev/forkhandles/result4k/ResultKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n57#2:126\n77#2,4:127\n57#2:131\n77#2,4:132\n57#2:136\n77#2,4:137\n48#2,4:141\n57#2:146\n77#2,4:147\n48#2,4:151\n86#2:155\n92#2:157\n86#2:159\n92#2:161\n1#3:145\n1#3:156\n1#3:158\n1#3:160\n1#3:162\n*S KotlinDebug\n*F\n+ 1 Processing.kt\norg/http4k/postbox/processing/PostboxProcessing\n*L\n76#1:126\n76#1:127,4\n84#1:131\n84#1:132,4\n88#1:136\n88#1:137,4\n89#1:141,4\n94#1:146\n94#1:147,4\n95#1:151,4\n47#1:155\n48#1:157\n72#1:159\n73#1:161\n47#1:156\n48#1:158\n72#1:160\n73#1:162\n*E\n"})
public final class PostboxProcessing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Transactor<Postbox> transactor;
    @NotNull
    private final Function1<Request, Response> target;
    private final int batchSize;
    private final int maxFailures;
    @NotNull
    private final java.time.Duration maxPollingTime;
    @NotNull
    private final Function1<Event, Unit> events;
    @NotNull
    private final ExecutionContext context;
    @NotNull
    private final Function2<Integer, Function1<? super Integer, Integer>, java.time.Duration> backoffStrategy;
    @NotNull
    private final Function1<Response, Boolean> successCriteria;
    @NotNull
    private final Runnable task;

    public PostboxProcessing(@NotNull Transactor<? extends Postbox> transactor, @NotNull Function1<? super Request, ? extends Response> target, int batchSize, int maxFailures, @NotNull java.time.Duration maxPollingTime, @NotNull Function1<? super Event, Unit> events, @NotNull ExecutionContext context, @NotNull Function2<? super Integer, ? super Function1<? super Integer, Integer>, java.time.Duration> backoffStrategy, @NotNull Function1<? super Response, Boolean> successCriteria) {
        Intrinsics.checkNotNullParameter(transactor, (String)"transactor");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)maxPollingTime, (String)"maxPollingTime");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(backoffStrategy, (String)"backoffStrategy");
        Intrinsics.checkNotNullParameter(successCriteria, (String)"successCriteria");
        this.transactor = transactor;
        this.target = target;
        this.batchSize = batchSize;
        this.maxFailures = maxFailures;
        this.maxPollingTime = maxPollingTime;
        this.events = events;
        this.context = context;
        this.backoffStrategy = backoffStrategy;
        this.successCriteria = successCriteria;
        this.task = () -> PostboxProcessing.task$lambda$4(this);
    }

    public /* synthetic */ PostboxProcessing(Transactor transactor, Function1 function1, int n, int n2, java.time.Duration duration, Function1 function12, ExecutionContext executionContext, Function2 function2, Function1 function13, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 10;
        }
        if ((n3 & 8) != 0) {
            n2 = 3;
        }
        if ((n3 & 0x10) != 0) {
            java.time.Duration duration2 = java.time.Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n3 & 0x20) != 0) {
            function12 = PostboxProcessing::_init_$lambda$0;
        }
        if ((n3 & 0x40) != 0) {
            executionContext = DefaultExecutionContext.INSTANCE;
        }
        if ((n3 & 0x80) != 0) {
            function2 = (Function2)new Function2<Integer, Function1<? super Integer, ? extends Integer>, java.time.Duration>((Object)Companion){

                public final java.time.Duration invoke(int p0, Function1<? super Integer, Integer> p1) {
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    return ((Companion)this.receiver).defaultBackoffStrategy(p0, p1);
                }
            };
        }
        if ((n3 & 0x100) != 0) {
            function13 = PostboxProcessing::_init_$lambda$1;
        }
        this(transactor, (Function1<? super Request, ? extends Response>)function1, n, n2, duration, (Function1<? super Event, Unit>)function12, executionContext, (Function2<? super Integer, ? super Function1<? super Integer, Integer>, java.time.Duration>)function2, (Function1<? super Response, Boolean>)function13);
    }

    public final void stop() {
        this.context.stop();
    }

    public final void start() {
        this.context.start(this.task);
    }

    @NotNull
    public final Result<Integer, RequestProcessingError> processPendingRequests(@NotNull Function1<? super Response, Boolean> successCriteria) {
        Result result;
        Intrinsics.checkNotNullParameter(successCriteria, (String)"successCriteria");
        Result $this$mapFailure$iv = TransactorResultKt.performAsResult$default(this.transactor, null, arg_0 -> PostboxProcessing.processPendingRequests$lambda$7(this, successCriteria, arg_0), 1, null);
        boolean $i$f$mapFailure = false;
        Result $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
        boolean $i$f$flatMapFailure = false;
        Result result2 = $this$flatMapFailure$iv$iv;
        if (result2 instanceof Success) {
            result = $this$flatMapFailure$iv$iv;
        } else if (result2 instanceof Failure) {
            Object reason$iv = ((Failure)$this$flatMapFailure$iv$iv).getReason();
            boolean bl = false;
            Exception it = (Exception)reason$iv;
            boolean bl2 = false;
            String string = it.getMessage();
            if (string == null) {
                string = "";
            }
            RequestProcessingError requestProcessingError = new RequestProcessingError(string);
            result = (Result)new Failure((Object)requestProcessingError);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Result<Unit, RequestProcessingError> processPendingRequest(Postbox postbox, Postbox.PendingRequest pending, Function1<? super Response, Boolean> successCriteria) {
        Result result;
        Response response = (Response)this.target.invoke((Object)pending.getRequest());
        boolean bl = false;
        if (((Boolean)successCriteria.invoke((Object)response)).booleanValue()) {
            void $this$mapFailure$iv;
            Result<Unit, PostboxError> result2 = postbox.markProcessed(pending.getRequestId(), response);
            boolean $i$f$mapFailure = false;
            void $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
            boolean $i$f$flatMapFailure = false;
            void var10_23 = $this$flatMapFailure$iv$iv;
            if (var10_23 instanceof Success) {
                result = $this$flatMapFailure$iv$iv;
                return result;
            } else {
                if (!(var10_23 instanceof Failure)) throw new NoWhenBranchMatchedException();
                Object reason$iv = ((Failure)$this$flatMapFailure$iv$iv).getReason();
                boolean bl2 = false;
                PostboxError it = (PostboxError)reason$iv;
                boolean bl3 = false;
                RequestProcessingError requestProcessingError = new RequestProcessingError(it.getDescription());
                result = (Result)new Failure((Object)requestProcessingError);
            }
            return result;
        } else {
            Failure failure;
            if (pending.getFailures() >= this.maxFailures) {
                Result result3;
                void $this$flatMap$iv;
                Result result4;
                Result $this$mapFailure$iv = postbox.markDead(pending.getRequestId(), response);
                boolean $i$f$mapFailure = false;
                Result $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
                boolean $i$f$flatMapFailure = false;
                Result result5 = $this$flatMapFailure$iv$iv;
                if (result5 instanceof Success) {
                    result4 = $this$flatMapFailure$iv$iv;
                } else {
                    if (!(result5 instanceof Failure)) throw new NoWhenBranchMatchedException();
                    Object reason$iv = ((Failure)$this$flatMapFailure$iv$iv).getReason();
                    boolean bl4 = false;
                    PostboxError it = (PostboxError)reason$iv;
                    boolean bl5 = false;
                    RequestProcessingError requestProcessingError = new RequestProcessingError(it.getDescription());
                    result4 = (Result)new Failure((Object)requestProcessingError);
                }
                $this$mapFailure$iv = result4;
                boolean $i$f$flatMap = false;
                $this$flatMapFailure$iv$iv = $this$flatMap$iv;
                if ($this$flatMapFailure$iv$iv instanceof Success) {
                    Unit it = (Unit)((Success)$this$flatMap$iv).getValue();
                    boolean bl6 = false;
                    result3 = (Result)new Failure((Object)new RequestProcessingError(pending.getRequestId() + " did not pass success criteria after " + pending.getFailures() + " attempts. Marked as dead"));
                } else {
                    if (!($this$flatMapFailure$iv$iv instanceof Failure)) throw new NoWhenBranchMatchedException();
                    result3 = $this$flatMap$iv;
                }
                RequestProcessingError p0 = (RequestProcessingError)ResultKt.get((Result)result3);
                boolean bl7 = false;
                failure = new Failure((Object)p0);
            } else {
                Result result6;
                void $this$flatMap$iv;
                Result result7;
                void $this$mapFailure$iv;
                java.time.Duration delay = (java.time.Duration)this.backoffStrategy.invoke((Object)pending.getFailures(), PostboxProcessing::processPendingRequest$lambda$16$lambda$12);
                Result<Unit, PostboxError> p0 = postbox.markFailed(pending.getRequestId(), delay, response);
                boolean $i$f$mapFailure = false;
                void $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
                boolean $i$f$flatMapFailure = false;
                void reason$iv = $this$flatMapFailure$iv$iv;
                if (reason$iv instanceof Success) {
                    result7 = $this$flatMapFailure$iv$iv;
                } else {
                    if (!(reason$iv instanceof Failure)) throw new NoWhenBranchMatchedException();
                    Object reason$iv2 = ((Failure)$this$flatMapFailure$iv$iv).getReason();
                    boolean bl8 = false;
                    PostboxError it = (PostboxError)reason$iv2;
                    boolean bl9 = false;
                    RequestProcessingError requestProcessingError = new RequestProcessingError(it.getDescription());
                    result7 = (Result)new Failure((Object)requestProcessingError);
                }
                $this$mapFailure$iv = result7;
                boolean $i$f$flatMap = false;
                $this$flatMapFailure$iv$iv = $this$flatMap$iv;
                if ($this$flatMapFailure$iv$iv instanceof Success) {
                    Unit it = (Unit)((Success)$this$flatMap$iv).getValue();
                    boolean bl10 = false;
                    java.time.Duration duration = delay;
                    result6 = (Result)new Failure((Object)new RequestProcessingError(pending.getRequestId() + " did not pass success criteria. Marked as failed (failure #" + (pending.getFailures() + 1) + ", reprocessing in " + Duration.toString-impl((long)Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS))) + ")"));
                } else {
                    if (!($this$flatMapFailure$iv$iv instanceof Failure)) throw new NoWhenBranchMatchedException();
                    result6 = $this$flatMap$iv;
                }
                RequestProcessingError p02 = (RequestProcessingError)ResultKt.get((Result)result6);
                boolean bl11 = false;
                failure = new Failure((Object)p02);
            }
            result = (Result)failure;
        }
        return result;
    }

    private static final Unit _init_$lambda$0(Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$1(Response it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStatus().getSuccessful();
    }

    /*
     * WARNING - void declaration
     */
    private static final void task$lambda$4(PostboxProcessing this$0) {
        while (this$0.context.isRunning()) {
            java.time.Duration remainingTime;
            void $this$peekFailure$iv;
            void $this$peek$iv;
            void var6_6;
            Instant t0 = this$0.context.currentTime();
            Result<Integer, RequestProcessingError> result = this$0.processPendingRequests(this$0.successCriteria);
            java.time.Duration elapsedTime = java.time.Duration.between(t0, this$0.context.currentTime());
            Result<Integer, RequestProcessingError> result2 = result;
            boolean $i$f$peek = false;
            void $this$peek_u24lambda_u245$iv = var6_6 = $this$peek$iv;
            boolean bl = false;
            if ($this$peek_u24lambda_u245$iv instanceof Success) {
                int it = ((Number)((Success)$this$peek_u24lambda_u245$iv).getValue()).intValue();
                boolean bl2 = false;
                Function1<Event, Unit> function1 = this$0.events;
                Intrinsics.checkNotNull((Object)elapsedTime);
                function1.invoke((Object)new ProcessingEvent.BatchProcessingSucceeded(it, elapsedTime));
            }
            $this$peek$iv = var6_6;
            boolean $i$f$peekFailure = false;
            void $this$peekFailure_u24lambda_u246$iv = var6_6 = $this$peekFailure$iv;
            boolean bl3 = false;
            if ($this$peekFailure_u24lambda_u246$iv instanceof Failure) {
                RequestProcessingError it = (RequestProcessingError)((Failure)$this$peekFailure_u24lambda_u246$iv).getReason();
                boolean bl4 = false;
                this$0.events.invoke((Object)new ProcessingEvent.BatchProcessingFailed(it.getReason()));
            }
            if ((remainingTime = this$0.maxPollingTime.minus(elapsedTime)).compareTo(java.time.Duration.ZERO) <= 0) continue;
            Function1<Event, Unit> function1 = this$0.events;
            Intrinsics.checkNotNull((Object)remainingTime);
            function1.invoke((Object)new ProcessingEvent.PollWait(remainingTime));
            this$0.context.pause(remainingTime);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final int processPendingRequests$lambda$7(PostboxProcessing this$0, Function1 $successCriteria, Postbox postbox) {
        Intrinsics.checkNotNullParameter((Object)postbox, (String)"postbox");
        List<Postbox.PendingRequest> pendingRequests = postbox.pendingRequests(this$0.batchSize, this$0.context.currentTime());
        for (Postbox.PendingRequest pending : pendingRequests) {
            void $this$peekFailure$iv;
            Object it;
            void $this$peek$iv;
            void var8_8;
            Result<Unit, RequestProcessingError> result = this$0.processPendingRequest(postbox, pending, (Function1<? super Response, Boolean>)$successCriteria);
            boolean $i$f$peek = false;
            void $this$peek_u24lambda_u245$iv = var8_8 = $this$peek$iv;
            boolean bl = false;
            if ($this$peek_u24lambda_u245$iv instanceof Success) {
                it = (Unit)((Success)$this$peek_u24lambda_u245$iv).getValue();
                boolean bl2 = false;
                this$0.events.invoke((Object)new ProcessingEvent.RequestProcessingSucceeded(pending.getRequestId()));
            }
            $this$peek$iv = var8_8;
            boolean $i$f$peekFailure = false;
            void $this$peekFailure_u24lambda_u246$iv = var8_8 = $this$peekFailure$iv;
            boolean bl3 = false;
            if (!($this$peekFailure_u24lambda_u246$iv instanceof Failure)) continue;
            it = (RequestProcessingError)((Failure)$this$peekFailure_u24lambda_u246$iv).getReason();
            boolean bl4 = false;
            this$0.events.invoke((Object)new ProcessingEvent.RequestProcessingFailed(((RequestProcessingError)it).getReason()));
        }
        return pendingRequests.size();
    }

    private static final int processPendingRequest$lambda$16$lambda$12(int it) {
        return RangesKt.random((IntRange)new IntRange(0, it), (Random)((Random)Random.Default));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tj\u0002`\n\u00a8\u0006\u000b"}, d2={"Lorg/http4k/postbox/processing/PostboxProcessing$Companion;", "", "<init>", "()V", "defaultBackoffStrategy", "Ljava/time/Duration;", "failures", "", "random", "Lkotlin/Function1;", "Lorg/http4k/postbox/processing/RandomSource;", "http4k-incubator-db"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final java.time.Duration defaultBackoffStrategy(int failures, @NotNull Function1<? super Integer, Integer> random) {
            Intrinsics.checkNotNullParameter(random, (String)"random");
            java.time.Duration duration = java.time.Duration.ofMillis((long)(Math.pow(2.0, failures) * (double)java.time.Duration.ofSeconds(5L).toMillis() + (double)(((Number)random.invoke((Object)10)).intValue() * 1000)));
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            return duration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

