/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.postbox.storage.inmemory;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.postbox.Postbox;
import org.http4k.postbox.PostboxError;
import org.http4k.postbox.RequestId;
import org.http4k.postbox.RequestProcessingStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002)*B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\fH\u0002J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J.\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J&\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\"0\u00152\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0004H\u0016R\u001b\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/http4k/postbox/storage/inmemory/InMemoryPostbox;", "Lorg/http4k/postbox/Postbox;", "timeSource", "Lkotlin/Function0;", "Ljava/time/Instant;", "Ldev/forkhandles/time/TimeSource;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getTimeSource", "()Lkotlin/jvm/functions/Function0;", "requests", "", "Lorg/http4k/postbox/RequestId;", "Lorg/http4k/postbox/storage/inmemory/InMemoryPostbox$Record;", "fail", "", "failNext", "", "findRequest", "requestId", "store", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/postbox/RequestProcessingStatus;", "Lorg/http4k/postbox/PostboxError;", "request", "Lorg/http4k/core/Request;", "markProcessed", "response", "Lorg/http4k/core/Response;", "markFailed", "delayReprocessing", "Ljava/time/Duration;", "markDead", "status", "Lorg/http4k/postbox/PostboxError$RequestNotFound;", "pendingRequests", "", "Lorg/http4k/postbox/Postbox$PendingRequest;", "batchSize", "", "atTime", "Record", "Status", "http4k-incubator-db"})
@SourceDebugExtension(value={"SMAP\nInMemoryPostbox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryPostbox.kt\norg/http4k/postbox/storage/inmemory/InMemoryPostbox\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,127:1\n536#2:128\n521#2,6:129\n126#3:135\n153#3,3:136\n*S KotlinDebug\n*F\n+ 1 InMemoryPostbox.kt\norg/http4k/postbox/storage/inmemory/InMemoryPostbox\n*L\n111#1:128\n111#1:129,6\n112#1:135\n112#1:136,3\n*E\n"})
public final class InMemoryPostbox
implements Postbox {
    @NotNull
    private final Function0<Instant> timeSource;
    @NotNull
    private final Map<RequestId, Record> requests;
    private boolean fail;

    public InMemoryPostbox(@NotNull Function0<Instant> timeSource) {
        Intrinsics.checkNotNullParameter(timeSource, (String)"timeSource");
        this.timeSource = timeSource;
        this.requests = new LinkedHashMap();
    }

    @NotNull
    public final Function0<Instant> getTimeSource() {
        return this.timeSource;
    }

    public final void failNext() {
        this.fail = true;
    }

    private final Record findRequest(RequestId requestId) {
        return this.requests.get((Object)requestId);
    }

    @Override
    @NotNull
    public Result<RequestProcessingStatus, PostboxError> store(@NotNull RequestId requestId, @NotNull Request request) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)((Object)requestId), (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!this.fail) {
            Success success;
            Instant now = (Instant)this.timeSource.invoke();
            Record existingRequest = this.findRequest(requestId);
            if (existingRequest == null) {
                this.requests.put(requestId, new Record(now, request, null, null, 0, 28, null));
                success = new Success((Object)new RequestProcessingStatus.Pending(0, now));
            } else {
                Response response = existingRequest.getResponse();
                success = response == null ? new Success((Object)new RequestProcessingStatus.Pending(existingRequest.getFailures(), existingRequest.getProcessAt())) : new Success((Object)new RequestProcessingStatus.Processed(response));
            }
            result = (Result)success;
        } else {
            this.fail = false;
            result = (Result)new Failure((Object)new PostboxError.StorageFailure(new IllegalStateException("Failed to store request")));
        }
        return result;
    }

    @Override
    @NotNull
    public Result<Unit, PostboxError> markProcessed(@NotNull RequestId requestId, @NotNull Response response) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)((Object)requestId), (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Record record = this.findRequest(requestId);
        if (record != null) {
            Record it = record;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getStatus().ordinal()]) {
                case 1: {
                    Map<RequestId, Record> map = this.requests;
                    Instant instant = it.getProcessAt();
                    Request request = it.getRequest();
                    Response response2 = it.getResponse();
                    if (response2 == null) {
                        response2 = response;
                    }
                    Record record2 = new Record(instant, request, response2, Status.PROCESSED, 0, 16, null);
                    map.put(requestId, record2);
                    result = (Result)new Success((Object)Unit.INSTANCE);
                    break;
                }
                case 2: {
                    result = (Result)new Failure((Object)PostboxError.Companion.getRequestAlreadyProcessed());
                    break;
                }
                case 3: {
                    result = (Result)new Failure((Object)PostboxError.Companion.getRequestMarkedAsDead());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        } else {
            result = (Result)new Failure((Object)PostboxError.RequestNotFound.INSTANCE);
        }
        return result;
    }

    @Override
    @NotNull
    public Result<Unit, PostboxError> markFailed(@NotNull RequestId requestId, @NotNull Duration delayReprocessing, @Nullable Response response) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)((Object)requestId), (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)delayReprocessing, (String)"delayReprocessing");
        Record record = this.findRequest(requestId);
        if (record != null) {
            Record it = record;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getStatus().ordinal()]) {
                case 1: {
                    Map<RequestId, Record> map = this.requests;
                    Instant instant = it.getProcessAt().plus(delayReprocessing);
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
                    Request request = it.getRequest();
                    Response response2 = it.getResponse();
                    if (response2 == null) {
                        response2 = response;
                    }
                    Record record2 = new Record(instant, request, response2, null, it.getFailures() + 1, 8, null);
                    map.put(requestId, record2);
                    result = (Result)new Success((Object)Unit.INSTANCE);
                    break;
                }
                case 2: {
                    result = (Result)new Failure((Object)PostboxError.Companion.getRequestAlreadyProcessed());
                    break;
                }
                case 3: {
                    result = (Result)new Failure((Object)PostboxError.Companion.getRequestMarkedAsDead());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        } else {
            result = (Result)new Failure((Object)PostboxError.RequestNotFound.INSTANCE);
        }
        return result;
    }

    @Override
    @NotNull
    public Result<Unit, PostboxError> markDead(@NotNull RequestId requestId, @Nullable Response response) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)((Object)requestId), (String)"requestId");
        Record record = this.findRequest(requestId);
        if (record != null) {
            Record it = record;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getStatus().ordinal()]) {
                case 1: {
                    Map<RequestId, Record> map = this.requests;
                    Instant instant = it.getProcessAt();
                    Request request = it.getRequest();
                    Response response2 = it.getResponse();
                    if (response2 == null) {
                        response2 = response;
                    }
                    Record record2 = new Record(instant, request, response2, Status.DEAD, 0, 16, null);
                    map.put(requestId, record2);
                    result = (Result)new Success((Object)Unit.INSTANCE);
                    break;
                }
                case 2: {
                    result = (Result)new Failure((Object)PostboxError.Companion.getRequestAlreadyProcessed());
                    break;
                }
                case 3: {
                    Map<RequestId, Record> map = this.requests;
                    Instant instant = it.getProcessAt();
                    Request request = it.getRequest();
                    Response response3 = it.getResponse();
                    if (response3 == null) {
                        response3 = response;
                    }
                    Record record3 = new Record(instant, request, response3, Status.DEAD, 0, 16, null);
                    map.put(requestId, record3);
                    result = (Result)new Success((Object)Unit.INSTANCE);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        } else {
            result = (Result)new Failure((Object)PostboxError.RequestNotFound.INSTANCE);
        }
        return result;
    }

    @NotNull
    public Result<RequestProcessingStatus, PostboxError.RequestNotFound> status(@NotNull RequestId requestId) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)((Object)requestId), (String)"requestId");
        Record record = this.findRequest(requestId);
        if (record != null) {
            Record it = record;
            boolean bl = false;
            result = (Result)(switch (WhenMappings.$EnumSwitchMapping$0[it.getStatus().ordinal()]) {
                case 1 -> new Success((Object)new RequestProcessingStatus.Pending(it.getFailures(), it.getProcessAt()));
                case 2 -> {
                    Response v2 = it.getResponse();
                    Intrinsics.checkNotNull((Object)v2);
                    yield new Success((Object)new RequestProcessingStatus.Processed(v2));
                }
                case 3 -> new Success((Object)new RequestProcessingStatus.Dead(it.getResponse()));
                default -> throw new NoWhenBranchMatchedException();
            });
        } else {
            result = (Result)new Failure((Object)PostboxError.RequestNotFound.INSTANCE);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Postbox.PendingRequest> pendingRequests(int batchSize, @NotNull Instant atTime) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        Map<RequestId, Record> $this$filter$iv = this.requests;
        boolean $i$f$filter = false;
        Map<RequestId, Record> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((Record)it.getValue()).getStatus() == Status.PENDING && ((Record)it.getValue()).getProcessAt().compareTo(atTime) <= 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(new Postbox.PendingRequest((RequestId)((Object)it.getKey()), ((Record)it.getValue()).getRequest(), ((Record)it.getValue()).getProcessAt(), ((Record)it.getValue()).getFailures()));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003J=\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lorg/http4k/postbox/storage/inmemory/InMemoryPostbox$Record;", "", "processAt", "Ljava/time/Instant;", "request", "Lorg/http4k/core/Request;", "response", "Lorg/http4k/core/Response;", "status", "Lorg/http4k/postbox/storage/inmemory/InMemoryPostbox$Status;", "failures", "", "<init>", "(Ljava/time/Instant;Lorg/http4k/core/Request;Lorg/http4k/core/Response;Lorg/http4k/postbox/storage/inmemory/InMemoryPostbox$Status;I)V", "getProcessAt", "()Ljava/time/Instant;", "getRequest", "()Lorg/http4k/core/Request;", "getResponse", "()Lorg/http4k/core/Response;", "getStatus", "()Lorg/http4k/postbox/storage/inmemory/InMemoryPostbox$Status;", "getFailures", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "http4k-incubator-db"})
    private static final class Record {
        @NotNull
        private final Instant processAt;
        @NotNull
        private final Request request;
        @Nullable
        private final Response response;
        @NotNull
        private final Status status;
        private final int failures;

        public Record(@NotNull Instant processAt, @NotNull Request request, @Nullable Response response, @NotNull Status status, int failures) {
            Intrinsics.checkNotNullParameter((Object)processAt, (String)"processAt");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            this.processAt = processAt;
            this.request = request;
            this.response = response;
            this.status = status;
            this.failures = failures;
        }

        public /* synthetic */ Record(Instant instant, Request request, Response response, Status status, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                response = null;
            }
            if ((n2 & 8) != 0) {
                status = Status.PENDING;
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            this(instant, request, response, status, n);
        }

        @NotNull
        public final Instant getProcessAt() {
            return this.processAt;
        }

        @NotNull
        public final Request getRequest() {
            return this.request;
        }

        @Nullable
        public final Response getResponse() {
            return this.response;
        }

        @NotNull
        public final Status getStatus() {
            return this.status;
        }

        public final int getFailures() {
            return this.failures;
        }

        @NotNull
        public final Instant component1() {
            return this.processAt;
        }

        @NotNull
        public final Request component2() {
            return this.request;
        }

        @Nullable
        public final Response component3() {
            return this.response;
        }

        @NotNull
        public final Status component4() {
            return this.status;
        }

        public final int component5() {
            return this.failures;
        }

        @NotNull
        public final Record copy(@NotNull Instant processAt, @NotNull Request request, @Nullable Response response, @NotNull Status status, int failures) {
            Intrinsics.checkNotNullParameter((Object)processAt, (String)"processAt");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            return new Record(processAt, request, response, status, failures);
        }

        public static /* synthetic */ Record copy$default(Record record, Instant instant, Request request, Response response, Status status, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                instant = record.processAt;
            }
            if ((n2 & 2) != 0) {
                request = record.request;
            }
            if ((n2 & 4) != 0) {
                response = record.response;
            }
            if ((n2 & 8) != 0) {
                status = record.status;
            }
            if ((n2 & 0x10) != 0) {
                n = record.failures;
            }
            return record.copy(instant, request, response, status, n);
        }

        @NotNull
        public String toString() {
            return "Record(processAt=" + this.processAt + ", request=" + this.request + ", response=" + this.response + ", status=" + this.status + ", failures=" + this.failures + ")";
        }

        public int hashCode() {
            int result = this.processAt.hashCode();
            result = result * 31 + this.request.hashCode();
            result = result * 31 + (this.response == null ? 0 : this.response.hashCode());
            result = result * 31 + this.status.hashCode();
            result = result * 31 + Integer.hashCode(this.failures);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Record)) {
                return false;
            }
            Record record = (Record)other;
            if (!Intrinsics.areEqual((Object)this.processAt, (Object)record.processAt)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.request, (Object)record.request)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.response, (Object)record.response)) {
                return false;
            }
            if (this.status != record.status) {
                return false;
            }
            return this.failures == record.failures;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/http4k/postbox/storage/inmemory/InMemoryPostbox$Status;", "", "<init>", "(Ljava/lang/String;I)V", "PENDING", "PROCESSED", "DEAD", "http4k-incubator-db"})
    private static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status PENDING = new Status();
        public static final /* enum */ Status PROCESSED = new Status();
        public static final /* enum */ Status DEAD = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.PENDING, Status.PROCESSED, Status.DEAD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.PENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.PROCESSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.DEAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

