/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing.experimental;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.ContentType;
import org.http4k.core.MemoryResponse;
import org.http4k.core.Request;
import org.http4k.core.etag.ETag;
import org.http4k.routing.experimental.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/http4k/routing/experimental/FileResource;", "Lorg/http4k/routing/experimental/Resource;", "file", "Ljava/io/File;", "contentType", "Lorg/http4k/core/ContentType;", "(Ljava/io/File;Lorg/http4k/core/ContentType;)V", "getContentType", "()Lorg/http4k/core/ContentType;", "lastModified", "Ljava/time/Instant;", "getLastModified", "()Ljava/time/Instant;", "length", "", "getLength", "()Ljava/lang/Long;", "openStream", "Ljava/io/InputStream;", "http4k-incubator"})
public final class FileResource
implements Resource {
    @NotNull
    private final File file;
    @NotNull
    private final ContentType contentType;

    public FileResource(@NotNull File file, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.file = file;
        this.contentType = contentType;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public InputStream openStream() {
        return new FileInputStream(this.file);
    }

    @Override
    @NotNull
    public Long getLength() {
        return this.file.length();
    }

    @Override
    @NotNull
    public Instant getLastModified() {
        Instant instant = Instant.ofEpochMilli(this.file.lastModified());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(file.lastModified())");
        return instant;
    }

    @Override
    @Nullable
    public ETag getEtag() {
        return Resource.DefaultImpls.getEtag(this);
    }

    @Override
    public boolean isModifiedSince(@NotNull Instant instant) {
        return Resource.DefaultImpls.isModifiedSince(this, instant);
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getHeaders() {
        return Resource.DefaultImpls.getHeaders(this);
    }

    @Override
    @NotNull
    public MemoryResponse invoke(@NotNull Request request) {
        return Resource.DefaultImpls.invoke(this, request);
    }
}

