/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing.experimental;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.routing.Router;
import org.http4k.routing.RouterMatch;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0011\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/http4k/routing/experimental/ResourceLoadingHandler;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "pathSegments", "", "resourceLoader", "Lorg/http4k/routing/Router;", "(Ljava/lang/String;Lorg/http4k/routing/Router;)V", "convertPath", "path", "invoke", "request", "http4k-incubator"})
public final class ResourceLoadingHandler
implements Function1<Request, Response> {
    @NotNull
    private final String pathSegments;
    @NotNull
    private final Router resourceLoader;

    public ResourceLoadingHandler(@NotNull String pathSegments, @NotNull Router resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)pathSegments, (String)"pathSegments");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.pathSegments = pathSegments;
        this.resourceLoader = resourceLoader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Response invoke(@NotNull Request request) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.getMethod() == Method.GET && StringsKt.startsWith$default((String)request.getUri().getPath(), (String)this.pathSegments, (boolean)false, (int)2, null)) {
            RouterMatch matchResult = this.resourceLoader.match(request.uri(Uri.Companion.of(this.convertPath(request.getUri().getPath()))));
            if (matchResult instanceof RouterMatch.MatchingHandler) {
                response = ((RouterMatch.MatchingHandler)matchResult).invoke(request);
                return response;
            } else if (matchResult instanceof RouterMatch.MethodNotMatched) {
                response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.METHOD_NOT_ALLOWED, null, (int)2, null);
                return response;
            } else if (matchResult instanceof RouterMatch.Unmatched) {
                response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.NOT_FOUND, null, (int)2, null);
                return response;
            } else {
                if (!(matchResult instanceof RouterMatch.MatchedWithoutHandler)) throw new NoWhenBranchMatchedException();
                response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.NOT_FOUND, null, (int)2, null);
            }
            return response;
        } else {
            response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.NOT_FOUND, null, (int)2, null);
        }
        return response;
    }

    private final String convertPath(String path) {
        return Intrinsics.areEqual((Object)this.pathSegments, (Object)"/") || Intrinsics.areEqual((Object)this.pathSegments, (Object)"") ? path : StringsKt.replace$default((String)path, (String)this.pathSegments, (String)"", (boolean)false, (int)4, null);
    }
}

