/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing.experimental;

import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.http4k.core.Filter;
import org.http4k.core.MimeTypes;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.routing.Router;
import org.http4k.routing.RouterDescription;
import org.http4k.routing.RouterMatch;
import org.http4k.routing.experimental.FileResource;
import org.http4k.routing.experimental.Path_utilsKt;
import org.http4k.routing.experimental.ResourceListingHandler;
import org.http4k.routing.experimental.ResourceLoading;
import org.http4k.routing.experimental.ResourceSummary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001Bt\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012[\b\u0002\u0010\u0006\u001aU\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007j\u0004\u0018\u0001`\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\\\u0010\u001a\u001aU\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007j\u0004\u0018\u0001`\u0010H\u00c6\u0003Jz\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052[\b\u0002\u0010\u0006\u001aU\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007j\u0004\u0018\u0001`\u0010H\u00c6\u0001Jg\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u001e2U\u0010\u001f\u001aQ\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00030\u0007j\u0002`\u0010H\u0002J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0002J$\u0010(\u001a\u0016\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+\u0018\u00010)j\u0004\u0018\u0001`,2\u0006\u0010'\u001a\u00020\u0003H\u0016J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001J\u0014\u0010.\u001a\u00020!*\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013Rd\u0010\u0006\u001aU\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007j\u0004\u0018\u0001`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006/"}, d2={"Lorg/http4k/routing/experimental/DirectoryResourceLoader;", "Lorg/http4k/routing/experimental/ResourceLoading;", "baseDir", "", "mimeTypes", "Lorg/http4k/core/MimeTypes;", "directoryRenderer", "Lkotlin/Function3;", "Lorg/http4k/core/Uri;", "Lkotlin/ParameterName;", "name", "uri", "Lorg/http4k/routing/experimental/ResourceSummary;", "dir", "", "resources", "Lorg/http4k/routing/experimental/DirectoryRenderer;", "(Ljava/lang/String;Lorg/http4k/core/MimeTypes;Lkotlin/jvm/functions/Function3;)V", "getBaseDir", "()Ljava/lang/String;", "getDirectoryRenderer", "()Lkotlin/jvm/functions/Function3;", "getMimeTypes", "()Lorg/http4k/core/MimeTypes;", "component1", "component2", "component3", "copy", "directoryRenderingHandler", "Lorg/http4k/routing/experimental/ResourceListingHandler;", "Ljava/io/File;", "renderer", "equals", "", "other", "", "hashCode", "", "indexFileIn", "path", "match", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "toString", "isUnder", "http4k-incubator"})
public final class DirectoryResourceLoader
implements ResourceLoading {
    @NotNull
    private final String baseDir;
    @NotNull
    private final MimeTypes mimeTypes;
    @Nullable
    private final Function3<Uri, ResourceSummary, Iterable<ResourceSummary>, String> directoryRenderer;

    @Override
    @Nullable
    public Function1<Request, Response> match(@NotNull String path) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(Path_utilsKt.pathJoin(this.baseDir, path));
        boolean bl = false;
        boolean bl2 = false;
        File $this$with = file;
        boolean bl3 = false;
        if (!this.isUnder($this$with, this.baseDir)) {
            function1 = null;
        } else if ($this$with.isFile()) {
            function1 = new FileResource($this$with, this.mimeTypes.forFile(path));
        } else if ($this$with.isDirectory()) {
            function1 = this.match(this.indexFileIn(path));
            if (function1 == null) {
                ResourceListingHandler resourceListingHandler;
                Function3<Uri, ResourceSummary, Iterable<ResourceSummary>, String> function3 = this.directoryRenderer;
                if (function3 != null) {
                    Function3<Uri, ResourceSummary, Iterable<ResourceSummary>, String> function32 = function3;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Function3<Uri, ResourceSummary, Iterable<ResourceSummary>, String> it = function32;
                    boolean bl6 = false;
                    resourceListingHandler = this.directoryRenderingHandler($this$with, it);
                } else {
                    resourceListingHandler = null;
                }
                function1 = resourceListingHandler;
            }
        } else {
            function1 = null;
        }
        return function1;
    }

    private final boolean isUnder(File $this$isUnder, String baseDir) {
        String string = $this$isUnder.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"canonicalPath");
        String string2 = new File(baseDir).getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"File(baseDir).canonicalPath");
        return StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null);
    }

    private final String indexFileIn(String path) {
        return Path_utilsKt.pathJoin(path, "index.html");
    }

    /*
     * WARNING - void declaration
     */
    private final ResourceListingHandler directoryRenderingHandler(File dir, Function3<? super Uri, ? super ResourceSummary, ? super Iterable<ResourceSummary>, String> renderer) {
        Collection<ResourceSummary> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = dir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dir.name");
        ResourceSummary resourceSummary = new ResourceSummary(string, Instant.ofEpochMilli(dir.lastModified()));
        Object[] objectArray = dir.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"dir.listFiles()");
        Object $this$sortedBy$iv = objectArray;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        $this$sortedBy$iv = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                it = (File)b;
                Comparable comparable = (Comparable)((Object)file.getName());
                bl2 = false;
                File file2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it");
                String string = file2.getName();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        });
        ResourceSummary resourceSummary2 = resourceSummary;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            String string2 = v3.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
            ResourceSummary resourceSummary3 = new ResourceSummary(string2, Instant.ofEpochMilli(it.lastModified()));
            collection.add(resourceSummary3);
        }
        collection = (List)destination$iv$iv;
        Function3<? super Uri, ? super ResourceSummary, ? super Iterable<ResourceSummary>, String> function3 = renderer;
        Iterable iterable = collection;
        ResourceSummary resourceSummary4 = resourceSummary2;
        return new ResourceListingHandler(resourceSummary4, iterable, function3);
    }

    @NotNull
    public final String getBaseDir() {
        return this.baseDir;
    }

    @NotNull
    public final MimeTypes getMimeTypes() {
        return this.mimeTypes;
    }

    @Nullable
    public final Function3<Uri, ResourceSummary, Iterable<ResourceSummary>, String> getDirectoryRenderer() {
        return this.directoryRenderer;
    }

    public DirectoryResourceLoader(@NotNull String baseDir, @NotNull MimeTypes mimeTypes, @Nullable Function3<? super Uri, ? super ResourceSummary, ? super Iterable<ResourceSummary>, String> directoryRenderer) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        this.baseDir = baseDir;
        this.mimeTypes = mimeTypes;
        this.directoryRenderer = directoryRenderer;
    }

    public /* synthetic */ DirectoryResourceLoader(String string, MimeTypes mimeTypes, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mimeTypes = MimeTypes.Companion.invoke$default((MimeTypes.Companion)MimeTypes.Companion, null, (int)1, null);
        }
        if ((n & 4) != 0) {
            function3 = null;
        }
        this(string, mimeTypes, (Function3<? super Uri, ? super ResourceSummary, ? super Iterable<ResourceSummary>, String>)function3);
    }

    @Override
    @NotNull
    public RouterMatch match(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return ResourceLoading.DefaultImpls.match(this, request);
    }

    @NotNull
    public RouterDescription getDescription() {
        return ResourceLoading.DefaultImpls.getDescription(this);
    }

    @NotNull
    public Router withBasePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"new");
        return ResourceLoading.DefaultImpls.withBasePath(this, string);
    }

    @NotNull
    public Router withFilter(@NotNull Filter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"new");
        return ResourceLoading.DefaultImpls.withFilter(this, filter);
    }

    @NotNull
    public final String component1() {
        return this.baseDir;
    }

    @NotNull
    public final MimeTypes component2() {
        return this.mimeTypes;
    }

    @Nullable
    public final Function3<Uri, ResourceSummary, Iterable<ResourceSummary>, String> component3() {
        return this.directoryRenderer;
    }

    @NotNull
    public final DirectoryResourceLoader copy(@NotNull String baseDir, @NotNull MimeTypes mimeTypes, @Nullable Function3<? super Uri, ? super ResourceSummary, ? super Iterable<ResourceSummary>, String> directoryRenderer) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        return new DirectoryResourceLoader(baseDir, mimeTypes, directoryRenderer);
    }

    public static /* synthetic */ DirectoryResourceLoader copy$default(DirectoryResourceLoader directoryResourceLoader, String string, MimeTypes mimeTypes, Function3 function3, int n, Object object) {
        if ((n & 1) != 0) {
            string = directoryResourceLoader.baseDir;
        }
        if ((n & 2) != 0) {
            mimeTypes = directoryResourceLoader.mimeTypes;
        }
        if ((n & 4) != 0) {
            function3 = directoryResourceLoader.directoryRenderer;
        }
        return directoryResourceLoader.copy(string, mimeTypes, function3);
    }

    @NotNull
    public String toString() {
        return "DirectoryResourceLoader(baseDir=" + this.baseDir + ", mimeTypes=" + this.mimeTypes + ", directoryRenderer=" + this.directoryRenderer + ")";
    }

    public int hashCode() {
        String string = this.baseDir;
        MimeTypes mimeTypes = this.mimeTypes;
        Function3<Uri, ResourceSummary, Iterable<ResourceSummary>, String> function3 = this.directoryRenderer;
        return ((string != null ? string.hashCode() : 0) * 31 + (mimeTypes != null ? mimeTypes.hashCode() : 0)) * 31 + (function3 != null ? function3.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DirectoryResourceLoader)) break block3;
                DirectoryResourceLoader directoryResourceLoader = (DirectoryResourceLoader)object;
                if (!Intrinsics.areEqual((Object)this.baseDir, (Object)directoryResourceLoader.baseDir) || !Intrinsics.areEqual((Object)this.mimeTypes, (Object)directoryResourceLoader.mimeTypes) || !Intrinsics.areEqual(this.directoryRenderer, directoryResourceLoader.directoryRenderer)) break block3;
            }
            return true;
        }
        return false;
    }
}

