/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing.experimental;

import java.io.InputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Body;
import org.http4k.core.ContentType;
import org.http4k.core.MemoryResponse;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.etag.ETag;
import org.http4k.core.etag.FieldValue;
import org.http4k.routing.experimental.ResourceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u0007J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0011\u0010$\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u0002H\u0096\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\b\u0010)\u001a\u00020*H&R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR0\u0010\u0010\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012j\u0002`\u00140\u0011j\u0002`\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lorg/http4k/routing/experimental/Resource;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "contentType", "Lorg/http4k/core/ContentType;", "getContentType", "()Lorg/http4k/core/ContentType;", "etag", "Lorg/http4k/core/etag/ETag;", "getEtag", "()Lorg/http4k/core/etag/ETag;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "getHeaders", "()Ljava/util/List;", "lastModified", "Ljava/time/Instant;", "getLastModified", "()Ljava/time/Instant;", "length", "", "getLength", "()Ljava/lang/Long;", "etagMatch", "", "fieldValue", "Lorg/http4k/core/etag/FieldValue;", "invoke", "Lorg/http4k/core/MemoryResponse;", "isModifiedSince", "instant", "notModifiedSince", "openStream", "Ljava/io/InputStream;", "http4k-incubator"})
public interface Resource
extends Function1<Request, Response> {
    @NotNull
    public InputStream openStream();

    @Nullable
    public Long getLength();

    @Nullable
    public Instant getLastModified();

    @NotNull
    public ContentType getContentType();

    @Nullable
    public ETag getEtag();

    public boolean isModifiedSince(@NotNull Instant var1);

    @NotNull
    public List<Pair<String, String>> getHeaders();

    @NotNull
    public MemoryResponse invoke(@NotNull Request var1);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Long getLength(@NotNull Resource $this) {
            return null;
        }

        @Nullable
        public static Instant getLastModified(@NotNull Resource $this) {
            return null;
        }

        @NotNull
        public static ContentType getContentType(@NotNull Resource $this) {
            return ContentType.Companion.getOCTET_STREAM();
        }

        @Nullable
        public static ETag getEtag(@NotNull Resource $this) {
            return null;
        }

        public static boolean isModifiedSince(@NotNull Resource $this, @NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            Instant instant2 = $this.getLastModified();
            return instant2 != null ? instant2.isAfter(instant) : true;
        }

        @NotNull
        public static List<Pair<String, String>> getHeaders(@NotNull Resource $this) {
            String string;
            Object[] objectArray = new Pair[4];
            objectArray[0] = TuplesKt.to((Object)"Content-Type", (Object)$this.getContentType().getValue());
            Long l = $this.getLength();
            objectArray[1] = TuplesKt.to((Object)"Content-Length", (Object)(l != null ? l.toString() : null));
            Instant instant = $this.getLastModified();
            if (instant != null) {
                DateTimeFormatter dateTimeFormatter = ResourceKt.access$getDateTimeFormatter$p();
                Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"dateTimeFormatter");
                string = ResourceKt.access$formattedWith(instant, dateTimeFormatter);
            } else {
                string = null;
            }
            objectArray[2] = TuplesKt.to((Object)"Last-Modified", string);
            ETag eTag = $this.getEtag();
            objectArray[3] = TuplesKt.to((Object)"ETag", (Object)(eTag != null ? eTag.toHeaderString() : null));
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public static MemoryResponse invoke(@NotNull Resource $this, @NotNull Request request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            return DefaultImpls.notModifiedSince($this, request) || DefaultImpls.etagMatch($this, request) ? new MemoryResponse(Status.NOT_MODIFIED, $this.getHeaders(), null, null, 12, null) : new MemoryResponse(Status.OK, $this.getHeaders(), Body.Companion.create($this.openStream(), $this.getLength()), null, 8, null);
        }

        private static boolean notModifiedSince(Resource $this, Request request) {
            Instant instant;
            String string = request.header("If-Modified-Since");
            if (string != null) {
                DateTimeFormatter dateTimeFormatter = ResourceKt.access$getDateTimeFormatter$p();
                Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"dateTimeFormatter");
                instant = ResourceKt.access$parsedWith(string, dateTimeFormatter);
            } else {
                instant = null;
            }
            Instant ifModifiedSince = instant;
            return ifModifiedSince != null && !$this.isModifiedSince(ifModifiedSince);
        }

        private static boolean etagMatch(Resource $this, Request request) {
            String string = request.header("If-None-Match");
            FieldValue fieldValue = string != null ? ResourceKt.access$parsedForEtags(string) : null;
            return fieldValue != null && DefaultImpls.etagMatch($this, fieldValue);
        }

        private static boolean etagMatch(Resource $this, FieldValue fieldValue) {
            ETag localEtag = $this.getEtag();
            return localEtag == null ? false : (fieldValue == FieldValue.Wildcard.INSTANCE ? true : (fieldValue instanceof FieldValue.ETags ? ResourceKt.access$hasAnEtagWithValue((FieldValue.ETags)fieldValue, localEtag.getValue()) : false));
        }
    }
}

