/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing.experimental;

import java.io.ByteArrayInputStream;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.ContentType;
import org.http4k.core.MemoryResponse;
import org.http4k.core.Request;
import org.http4k.core.etag.ETag;
import org.http4k.routing.experimental.Resource;
import org.http4k.routing.experimental.ResourceSummary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/http4k/routing/experimental/ResourceInfoResource;", "Lorg/http4k/routing/experimental/Resource;", "resourceSummary", "Lorg/http4k/routing/experimental/ResourceSummary;", "content", "", "contentType", "Lorg/http4k/core/ContentType;", "(Lorg/http4k/routing/experimental/ResourceSummary;[BLorg/http4k/core/ContentType;)V", "getContent", "()[B", "getContentType", "()Lorg/http4k/core/ContentType;", "lastModified", "Ljava/time/Instant;", "getLastModified", "()Ljava/time/Instant;", "length", "", "getLength", "()Ljava/lang/Long;", "openStream", "Ljava/io/ByteArrayInputStream;", "http4k-incubator"})
final class ResourceInfoResource
implements Resource {
    @NotNull
    private final byte[] content;
    @NotNull
    private final ContentType contentType;
    private final long length;
    @Nullable
    private final Instant lastModified;

    public ResourceInfoResource(@NotNull ResourceSummary resourceSummary, @NotNull byte[] content, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)resourceSummary, (String)"resourceSummary");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.content = content;
        this.contentType = contentType;
        this.length = this.content.length;
        this.lastModified = resourceSummary.getLastModified();
    }

    @NotNull
    public final byte[] getContent() {
        return this.content;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public ByteArrayInputStream openStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    @NotNull
    public Long getLength() {
        return this.length;
    }

    @Override
    @Nullable
    public Instant getLastModified() {
        return this.lastModified;
    }

    @Override
    @Nullable
    public ETag getEtag() {
        return Resource.DefaultImpls.getEtag(this);
    }

    @Override
    public boolean isModifiedSince(@NotNull Instant instant) {
        return Resource.DefaultImpls.isModifiedSince(this, instant);
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getHeaders() {
        return Resource.DefaultImpls.getHeaders(this);
    }

    @Override
    @NotNull
    public MemoryResponse invoke(@NotNull Request request) {
        return Resource.DefaultImpls.invoke(this, request);
    }
}

