/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing.experimental;

import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.ContentType;
import org.http4k.core.MemoryResponse;
import org.http4k.core.Request;
import org.http4k.core.etag.ETag;
import org.http4k.routing.experimental.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/http4k/routing/experimental/URLResource;", "Lorg/http4k/routing/experimental/Resource;", "url", "Ljava/net/URL;", "contentType", "Lorg/http4k/core/ContentType;", "lastModified", "Ljava/time/Instant;", "(Ljava/net/URL;Lorg/http4k/core/ContentType;Ljava/time/Instant;)V", "getContentType", "()Lorg/http4k/core/ContentType;", "getLastModified", "()Ljava/time/Instant;", "getUrl", "()Ljava/net/URL;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "openStream", "Ljava/io/InputStream;", "toString", "", "http4k-incubator"})
public final class URLResource
implements Resource {
    @NotNull
    private final URL url;
    @NotNull
    private final ContentType contentType;
    @Nullable
    private final Instant lastModified;

    public URLResource(@NotNull URL url, @NotNull ContentType contentType, @Nullable Instant lastModified) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.url = url;
        this.contentType = contentType;
        this.lastModified = lastModified;
    }

    public /* synthetic */ URLResource(URL uRL, ContentType contentType, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            instant = null;
        }
        this(uRL, contentType, instant);
    }

    @NotNull
    public final URL getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public Instant getLastModified() {
        return this.lastModified;
    }

    @Override
    @NotNull
    public InputStream openStream() {
        InputStream inputStream = this.url.openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"url.openStream()");
        return inputStream;
    }

    @Override
    @Nullable
    public Long getLength() {
        return Resource.DefaultImpls.getLength(this);
    }

    @Override
    @Nullable
    public ETag getEtag() {
        return Resource.DefaultImpls.getEtag(this);
    }

    @Override
    public boolean isModifiedSince(@NotNull Instant instant) {
        return Resource.DefaultImpls.isModifiedSince(this, instant);
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getHeaders() {
        return Resource.DefaultImpls.getHeaders(this);
    }

    @Override
    @NotNull
    public MemoryResponse invoke(@NotNull Request request) {
        return Resource.DefaultImpls.invoke(this, request);
    }

    @NotNull
    public final URL component1() {
        return this.url;
    }

    @NotNull
    public final ContentType component2() {
        return this.contentType;
    }

    @Nullable
    public final Instant component3() {
        return this.lastModified;
    }

    @NotNull
    public final URLResource copy(@NotNull URL url, @NotNull ContentType contentType, @Nullable Instant lastModified) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        return new URLResource(url, contentType, lastModified);
    }

    public static /* synthetic */ URLResource copy$default(URLResource uRLResource, URL uRL, ContentType contentType, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            uRL = uRLResource.url;
        }
        if ((n & 2) != 0) {
            contentType = uRLResource.contentType;
        }
        if ((n & 4) != 0) {
            instant = uRLResource.lastModified;
        }
        return uRLResource.copy(uRL, contentType, instant);
    }

    @NotNull
    public String toString() {
        return "URLResource(url=" + this.url + ", contentType=" + this.contentType + ", lastModified=" + this.lastModified + ')';
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = result * 31 + this.contentType.hashCode();
        result = result * 31 + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof URLResource)) {
            return false;
        }
        URLResource uRLResource = (URLResource)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)uRLResource.url)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentType, (Object)uRLResource.contentType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.lastModified, (Object)uRLResource.lastModified);
    }
}

